/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.services.bean.PollenBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.bean.VoteToChoiceBean;

public class VoteBean
extends PollenBean<Vote> {
    protected PollenEntityId<PollenPrincipal> voterId;
    protected Set<PollenEntityId<VoterListMember>> voterListMemberIds;
    protected String voterName;
    protected String voterAvatar;
    protected String permission;
    protected Boolean anonymous;
    protected double weight;
    protected final Set<VoteToChoiceBean> choice = new LinkedHashSet<VoteToChoiceBean>();
    private ReportResumeBean report;
    protected boolean ignored;

    public VoteBean() {
        super(Vote.class);
    }

    public String getVoterName() {
        return this.voterName;
    }

    public void setVoterName(String voterName) {
        this.voterName = voterName;
    }

    public String getVoterAvatar() {
        return this.voterAvatar;
    }

    public void setVoterAvatar(String voterAvatar) {
        this.voterAvatar = voterAvatar;
    }

    public PollenEntityId<PollenPrincipal> getVoterId() {
        if (this.voterId == null) {
            this.voterId = PollenEntityId.newId(PollenPrincipal.class);
        }
        return this.voterId;
    }

    public void setVoterId(PollenEntityId<PollenPrincipal> voterId) {
        this.voterId = voterId;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public Set<VoteToChoiceBean> getChoice() {
        return this.choice;
    }

    public void addChoice(VoteToChoiceBean choice) {
        this.choice.add(choice);
    }

    public boolean isAnonymous() {
        return this.anonymous != null && this.anonymous != false;
    }

    public Set<PollenEntityId<VoterListMember>> getVoterListMemberId() {
        if (this.voterListMemberIds == null) {
            this.voterListMemberIds = Sets.newHashSet();
        }
        return this.voterListMemberIds;
    }

    public void setVoterListMembers(Collection<VoterListMember> voterListMembers) {
        this.voterListMemberIds = voterListMembers.stream().map(member -> {
            PollenEntityId<VoterListMember> memberId = PollenEntityId.newId(VoterListMember.class);
            memberId.setEntityId(member.getTopiaId());
            return memberId;
        }).collect(Collectors.toSet());
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setReport(ReportResumeBean report) {
        this.report = report;
    }

    public ReportResumeBean getReport() {
        return this.report;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }
}

