/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import java.util.stream.Stream;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.PollenTechnicalException;

public enum PollenEmailKeyType {
    P(Poll.class),
    C(Choice.class),
    V(Vote.class),
    U(PollenUser.class),
    R(Report.class),
    O(Comment.class),
    E(PollenPrincipal.class);

    protected final Class<? extends PollenEntity> type;

    private PollenEmailKeyType(Class<? extends PollenEntity> type) {
        this.type = type;
    }

    public Class<? extends PollenEntity> getType() {
        return this.type;
    }

    public static PollenEmailKeyType valueOfType(Class<? extends PollenEntity> typeClass) {
        return Stream.of(PollenEmailKeyType.values()).filter(type -> type.getType().isAssignableFrom(typeClass)).findFirst().orElseThrow(() -> new PollenTechnicalException("unknown pollenEmailKeyType of " + String.valueOf(typeClass)));
    }

    public static PollenEmailKeyType valueOfEntity(PollenEntity entity) {
        return PollenEmailKeyType.valueOfType(entity.getClass());
    }
}

