/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Lists;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.SocialAuthConfig;
import org.brickred.socialauth.SocialAuthManager;
import org.brickred.socialauth.util.OAuthConfig;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.LoginProvider;
import org.chorem.pollen.persistence.entity.LoginProviderDao;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserDao;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.ResourceType;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.services.bean.LoginProviderBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.resource.ResourceStreamBean;
import org.chorem.pollen.services.service.PollenResourceService;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenEmailOrProviderAccountAlreadyUsedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialAuthService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(SocialAuthService.class);

    public PollenEntityRef<PollenUser> login(SocialAuthManager manager, Map<String, String> paramsMap) throws Exception {
        PollenUser pollenUser;
        AuthProvider provider = manager.connect(paramsMap);
        Profile p = provider.getUserProfile();
        PollenUserDao userDao = this.getPollenUserDao();
        PollenUser pollenUserForCredential = userDao.findUserWithCredentialOrNull(p.getProviderId(), p.getValidatedId());
        if (pollenUserForCredential != null) {
            if (log.isDebugEnabled()) {
                log.debug("credentials found");
            }
            pollenUser = pollenUserForCredential;
        } else {
            if (this.getPollenUserEmailAddressDao().emailExists(p.getEmail())) {
                throw new PollenEmailOrProviderAccountAlreadyUsedException();
            }
            Object name = p.getFullName();
            if (name == null) {
                name = p.getFirstName() + " " + p.getLastName();
            }
            if (log.isDebugEnabled()) {
                log.debug("create new user : " + (String)name);
            }
            UserCredential credential = this.createUserCredential(p);
            pollenUser = new PollenUser();
            pollenUser.setName((String)name);
            String credentialEmail = this.getCleanMail(credential.getEmail());
            if (StringUtils.isNotBlank((CharSequence)credentialEmail)) {
                PollenUserEmailAddress defaultEmailAddress = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().create();
                defaultEmailAddress.setEmailAddress(credentialEmail);
                pollenUser.addEmailAddresses(defaultEmailAddress);
                pollenUser.setDefaultEmailAddress(defaultEmailAddress);
            }
            pollenUser.setLanguage(p.getLanguage());
            pollenUser.setAdministrator(false);
            pollenUser.setBanned(false);
            pollenUser.addUserCredential(credential);
            pollenUser = (PollenUser)userDao.create((PollenEntity)pollenUser);
            this.commit();
            this.getNotificationService().onUserCreatedFromProvider(pollenUser, credential);
        }
        this.getSecurityContext().setPollenUser(pollenUser);
        return PollenEntityRef.of(pollenUser);
    }

    public String addCredentialToUser(SocialAuthManager manager, Map<String, String> paramsMap) throws Exception {
        boolean addEmailAddress;
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        AuthProvider provider = manager.connect(paramsMap);
        Profile p = provider.getUserProfile();
        String credentialEmail = this.getCleanMail(p.getEmail());
        boolean credentialValid = this.getUserCredentialDao().isCredentialValid(p.getProviderId(), p.getValidatedId(), connectedUser.getTopiaId(), credentialEmail);
        if (!credentialValid) {
            throw new PollenEmailOrProviderAccountAlreadyUsedException();
        }
        UserCredential credential = this.createUserCredential(p);
        connectedUser.addUserCredential(credential);
        if (StringUtils.isNotBlank((CharSequence)credential.getEmail()) && (addEmailAddress = connectedUser.getEmailAddresses().stream().map(PollenUserEmailAddress::getEmailAddress).noneMatch(email -> Objects.equals(credentialEmail, email)))) {
            PollenUserEmailAddress emailAddress = (PollenUserEmailAddress)this.getPollenUserEmailAddressDao().create();
            emailAddress.setEmailAddress(credentialEmail);
            connectedUser.addEmailAddresses(emailAddress);
        }
        this.commit();
        return credential.getUserName();
    }

    protected UserCredential createUserCredential(Profile p) {
        String accountName = p.getDisplayName();
        if (accountName == null) {
            accountName = p.getFullName();
        }
        String userEmail = null;
        if (StringUtils.isNotBlank((CharSequence)p.getEmail()) && !"null".equalsIgnoreCase(p.getEmail())) {
            userEmail = p.getEmail();
        }
        UserCredential credential = new UserCredential();
        credential.setProvider(p.getProviderId());
        credential.setUserId(p.getValidatedId());
        credential.setUserName(accountName);
        credential.setEmail(userEmail);
        credential = (UserCredential)this.getUserCredentialDao().create((PollenEntity)credential);
        return credential;
    }

    public SocialAuthManager createSocialAuthManager() throws Exception {
        this.checkIsConnectedRequired();
        SocialAuthConfig config = SocialAuthConfig.getDefault();
        List allActiveProviders = this.getLoginProviderDao().forActiveEquals(true).findAll();
        allActiveProviders.forEach(provider -> {
            block3: {
                try {
                    OAuthConfig providerConfig = new OAuthConfig(provider.getKey(), provider.getSecret());
                    if (StringUtils.isNotBlank((CharSequence)provider.getPermissions())) {
                        providerConfig.setCustomPermissions(provider.getPermissions());
                    }
                    config.addProviderConfig(provider.getName(), providerConfig);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("Error while adding config for provider " + provider.getName(), (Throwable)e);
                }
            }
        });
        config.load(new Properties());
        SocialAuthManager manager = new SocialAuthManager();
        manager.setSocialAuthConfig(config);
        return manager;
    }

    public LoginProviderBean toLoginProviderBean(LoginProvider entity) {
        LoginProviderBean bean = new LoginProviderBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setKey(entity.getKey());
        bean.setSecret(entity.getSecret());
        bean.setPermissions(entity.getPermissions());
        bean.setActive(entity.isActive());
        return bean;
    }

    public List<LoginProviderBean> getAllLoginProviders() {
        this.checkIsAdmin();
        LoginProviderDao dao = this.getLoginProviderDao();
        List loginProviders = dao.findAll();
        return this.toBeanList(loginProviders, this::toLoginProviderBean);
    }

    public List<String> getActiveLoginProviders() {
        LoginProviderDao dao = this.getLoginProviderDao();
        return dao.forActiveEquals(true).findAll().stream().map(LoginProvider::getName).collect(Collectors.toList());
    }

    public List<String> getAvailableLoginProviders() {
        this.checkIsAdmin();
        return Lists.newArrayList((Object[])new String[]{"amazon", "facebook", "flickr", "foursquare", "github", "googleplus", "hotmail", "instagram", "linkedin", "linkedin2", "mendeley", "myspace", "nimble", "runkeeper", "salesforce", "stackexchange", "twitter", "yahoo", "yammer"});
    }

    public LoginProviderBean saveLoginProvider(LoginProviderBean loginProvider, boolean loginProviderExists) {
        this.checkIsAdmin();
        this.checkNotNull(loginProvider);
        LoginProviderDao dao = this.getLoginProviderDao();
        LoginProvider toSave = loginProviderExists ? (LoginProvider)dao.forTopiaIdEquals(loginProvider.getEntityId()).findUnique() : (LoginProvider)dao.create();
        toSave.setName(loginProvider.getName());
        toSave.setKey(loginProvider.getKey());
        toSave.setSecret(loginProvider.getSecret());
        toSave.setPermissions(loginProvider.getPermissions());
        toSave.setActive(loginProvider.isActive());
        this.commit();
        return this.toLoginProviderBean(toSave);
    }

    public void deleteLoginProvider(String providerId) {
        this.checkIsAdmin();
        this.checkNotNull(providerId);
        LoginProviderDao dao = this.getLoginProviderDao();
        dao.delete((LoginProvider)dao.forTopiaIdEquals(providerId).findUnique());
        this.commit();
    }

    public void deleteUserCredential(PollenEntityId<UserCredential> credentialId) {
        this.checkNotNull(credentialId);
        PollenUser pollenUser = this.checkAndGetConnectedUser();
        UserCredential credential = pollenUser.getUserCredentialByTopiaId(credentialId.getEntityId());
        this.getUserCredentialDao().delete(credential);
        this.commit();
    }

    public void setAvatarToUser(SocialAuthManager manager, Map<String, String> paramsMap) throws Exception {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        PollenResourceService pollenResourceService = this.getPollenResourceService();
        if (connectedUser.getAvatar() != null) {
            this.getPollenResourceDao().delete(connectedUser.getAvatar());
        }
        AuthProvider provider = manager.connect(paramsMap);
        Profile p = provider.getUserProfile();
        String avatarUrl = p.getProfileImageURL();
        URLConnection connection = new URL(avatarUrl).openConnection();
        String contentType = connection.getContentType();
        ResourceStreamBean resourceStreamBean = new ResourceStreamBean();
        resourceStreamBean.setResourceContent(connection.getInputStream());
        resourceStreamBean.setName(connectedUser.getTopiaId());
        resourceStreamBean.setContentType(contentType);
        resourceStreamBean.setSize(connection.getContentLength());
        resourceStreamBean.setResourceType(ResourceType.AVATAR);
        PollenResource avatarResource = pollenResourceService.createAvatarResource(resourceStreamBean);
        connectedUser.setAvatar(avatarResource);
        this.commit();
    }
}

