/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.Date;
import java.util.Objects;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.Question;

public class Polls {
    public static boolean isPollFree(Poll poll) {
        return Objects.equals(PollType.FREE, poll.getPollType());
    }

    public static boolean isPollRestricted(Poll poll) {
        return Objects.equals(PollType.RESTRICTED, poll.getPollType());
    }

    public static boolean isPollRegistered(Poll poll) {
        return Objects.equals(PollType.REGISTERED, poll.getPollType());
    }

    public static boolean isStarted(Poll poll, Date currentDate) {
        Date beginDate = poll.getBeginDate();
        return beginDate == null || beginDate.before(currentDate);
    }

    public static boolean isRunning(Poll poll, Date currentDate) {
        return Polls.isStarted(poll, currentDate) && !Polls.isFinished(poll, currentDate);
    }

    public static boolean isFinished(Poll poll, Date currentDate) {
        Date endDate = poll.getEndDate();
        return endDate != null && currentDate.after(endDate);
    }

    public static boolean isAddChoiceStarted(Question question, Date currentDate) {
        Date beginChoiceDate = question.getBeginChoiceDate();
        return question.isChoiceAddAllowed() && (beginChoiceDate == null || beginChoiceDate.before(currentDate));
    }

    public static boolean isAddChoiceRunning(Question question, Date currentDate) {
        return question.isChoiceAddAllowed() && !Polls.isFinished(question.getPoll(), currentDate) && Polls.isAddChoiceStarted(question, currentDate) && !Polls.isAddChoiceFinished(question, currentDate);
    }

    public static boolean isAddChoiceFinished(Question question, Date currentDate) {
        Date endChoiceDate = question.getEndChoiceDate();
        return !question.isChoiceAddAllowed() || endChoiceDate != null && endChoiceDate.before(currentDate);
    }
}

