/*
 * #%L
 * Pollen :: Services
 * $Id: PollUrl.java 3513 2012-06-18 11:38:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-services/src/main/java/org/chorem/pollen/bean/PollUrl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

/**
 * Created: 12/04/12
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public class PollUrl {

    private String baseUrl;

    private PollUri pollUri;

    /**
     * Create a new PollUrl with {@code baseUrl} which is the application url
     * for this url, and the {@code pollUri} to identify the poll.
     *
     * @param baseUrl Base url from the application for this url
     * @param pollUri Uri that identify the poll and the account
     * @return a new PollUrl
     */
    public static PollUrl newPollUrl(String baseUrl, PollUri pollUri) {
        PollUrl result = new PollUrl();
        result.baseUrl = baseUrl;
        result.pollUri = pollUri;
        return result;
    }

    /**
     * Create a new PollUrl which is a copy of the given {@code pollUrl} with
     * an other {@code accountId} for {@link PollUri}.
     *
     * @param pollUrl   PollUrl to copy
     * @param accountId New accountId to use for copy
     * @return the new PollUrl
     */
    public static PollUrl newPollUrl(PollUrl pollUrl, String accountId) {
        PollUrl result = new PollUrl();
        result.baseUrl = pollUrl.getBaseUrl();
        String pollId = pollUrl.getPollUri().getPollId();
        result.pollUri = PollUri.newPollUri(pollId, accountId);
        return result;
    }

    private PollUrl() {
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public PollUri getPollUri() {
        return pollUri;
    }

    public String getUrl() {
        String result = getBaseUrl() + getPollUri().getUri();
        return result;
    }

    @Override
    public String toString() {
        return getUrl();
    }
}
