/*
 * Decompiled with CFR 0.152.
 */
package db.migration.common;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.entity.PollEvent;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3_5_0_8__Migrate_poll_feeds
extends BaseJavaMigration {
    private static final Logger log = LoggerFactory.getLogger(V3_5_0_8__Migrate_poll_feeds.class);
    private static final String INSERT_POLL_EVENT = "INSERT INTO poll_event (topia_id, topia_version, topia_create_date, poll, title) VALUES (?, 0, ?, ?, ?)";
    private static final String UPDATE_POLL_FEED_CONTENT = "UPDATE poll SET feed_content = NULL WHERE topia_id = ?";
    private static final String SELECT_POLL_FEED_CONTENT = "SELECT p.topia_id, p.feed_content FROM poll p WHERE p.feed_content IS NOT NULL";
    private static final String SELECT_COUNT_POLL_FEED_CONTENT = "SELECT count(p.topia_id) FROM poll p WHERE p.feed_content IS NOT NULL";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrate(Context context) throws SQLException {
        Connection connection = context.getConnection();
        try (Statement countStatement = connection.createStatement();
             ResultSet countResultSet = countStatement.executeQuery(SELECT_COUNT_POLL_FEED_CONTENT);){
            countResultSet.next();
            log.info("Starting migration of {} feeds...", (Object)countResultSet.getLong(1));
        }
        int feeds = 0;
        int events = 0;
        connection.setAutoCommit(false);
        try (PreparedStatement insertStatement = connection.prepareStatement(INSERT_POLL_EVENT);
             PreparedStatement updateStatement = connection.prepareStatement(UPDATE_POLL_FEED_CONTENT);
             Statement selectStatement = connection.createStatement();
             ResultSet resultSet = selectStatement.executeQuery(SELECT_POLL_FEED_CONTENT);){
            while (resultSet.next()) {
                String pollId = resultSet.getString(1);
                String feedContent = resultSet.getString(2);
                try {
                    SyndFeedInput feedInput = new SyndFeedInput(true, Locale.FRENCH);
                    SyndFeed feed = feedInput.build((Reader)new StringReader(feedContent));
                    List entries = feed.getEntries();
                    if (CollectionUtils.isNotEmpty((Collection)entries)) {
                        entries.removeFirst();
                        for (SyndEntry entry : entries) {
                            Date publishedDate = entry.getPublishedDate();
                            String title = entry.getTitle();
                            insertStatement.setString(1, TopiaIdFactory.newTopiaId(PollEvent.class));
                            insertStatement.setTimestamp(2, new Timestamp(publishedDate.getTime()));
                            insertStatement.setString(3, pollId);
                            insertStatement.setString(4, title);
                            insertStatement.addBatch();
                            ++events;
                        }
                    }
                    updateStatement.setString(1, pollId);
                    updateStatement.addBatch();
                    ++feeds;
                }
                catch (Exception e) {
                    log.error("Unable to process feed for Poll '{}'", (Object)pollId, (Object)e);
                }
            }
            resultSet.close();
            insertStatement.executeBatch();
            updateStatement.executeBatch();
            connection.commit();
        }
        log.info("{} feeds migrated ({} events created)", (Object)feeds, (Object)events);
    }
}

