/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.ChoiceDao;
import org.chorem.pollen.persistence.entity.ChoiceType;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.ResourceType;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class PollenResourceDao
extends AbstractPollenDao<PollenResource> {
    @Override
    public Class<PollenResource> getEntityClass() {
        return PollenResource.class;
    }

    public void deleteFromParent(PollenResource entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getPollenUserDao().forAvatarEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((PollenUser)item).getAvatar())) continue;
            ((PollenUser)item).setAvatar(null);
        }
        list = this.daoSupplier.getPollDao().forPictureEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Poll)item).getPicture())) continue;
            ((Poll)item).setPicture(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<PollenResource> forResourceTypeEquals(ResourceType v) {
        return this.forEquals("resourceType", (Object)v);
    }

    @Override
    public void delete(PollenResource entity) {
        ChoiceDao dao = this.daoSupplier.getChoiceDao();
        boolean isUsed = dao.forChoiceValueAndChoiceTypeEquals(entity.getTopiaId(), ChoiceType.RESOURCE).exists();
        if (!isUsed) {
            this.deleteFromParent(entity);
        }
    }

    public void delete(PollenResource entity, String choiceId) {
        ChoiceDao dao = this.daoSupplier.getChoiceDao();
        boolean isUsed = dao.forChoiceValueAndChoiceTypeEqualsAndTopiaIdNotEquals(entity.getTopiaId(), ChoiceType.RESOURCE, choiceId).exists();
        if (!isUsed) {
            this.deleteFromParent(entity);
        }
    }

    public PollenResource findAvatarForUser(String userId) {
        String hql = "SELECT avatar FROM " + PollenUser.class.getName() + " user  WHERE user.topiaId = :userId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        return (PollenResource)this.findUniqueOrNull(hql, params);
    }
}

