package org.chorem.pollen.business.persistence;

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface UserAccount extends TopiaEntity {

    String PROPERTY_LOGIN = "login";

    String PROPERTY_PASSWORD = "password";

    String PROPERTY_FIRST_NAME = "firstName";

    String PROPERTY_LAST_NAME = "lastName";

    String PROPERTY_ADMINISTRATOR = "administrator";

    String PROPERTY_LANGUAGE = "language";

    String PROPERTY_EMAIL = "email";

    String PROPERTY_FAVORITE_LIST = "favoriteList";

    String PROPERTY_POLL_ACCOUNT = "pollAccount";

    void setLogin(String login);

    String getLogin();

    void setPassword(String password);

    String getPassword();

    void setFirstName(String firstName);

    String getFirstName();

    void setLastName(String lastName);

    String getLastName();

    void setAdministrator(boolean administrator);

    boolean isAdministrator();

    void setLanguage(String language);

    String getLanguage();

    void setEmail(String email);

    String getEmail();

    void addFavoriteList(PersonList favoriteList);

    void addAllFavoriteList(List<PersonList> favoriteList);

    void setFavoriteList(List<PersonList> favoriteList);

    void removeFavoriteList(PersonList favoriteList);

    void clearFavoriteList();

    List<PersonList> getFavoriteList();

    PersonList getFavoriteListByTopiaId(String topiaId);

    int sizeFavoriteList();

    boolean isFavoriteListEmpty();

    void addPollAccount(PollAccount pollAccount);

    void addAllPollAccount(List<PollAccount> pollAccount);

    void setPollAccount(List<PollAccount> pollAccount);

    void removePollAccount(PollAccount pollAccount);

    void clearPollAccount();

    List<PollAccount> getPollAccount();

    PollAccount getPollAccountByTopiaId(String topiaId);

    int sizePollAccount();

    boolean isPollAccountEmpty();

    String getDisplayName();

} //UserAccount
