package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PollAccountAbstract extends TopiaEntityAbstract implements PollAccount {

    /**
     * Nom de l'attribut en BD : accountId
     */
    protected String accountId;

    /**
     * Nom de l'attribut en BD : votingId
     */
    protected String votingId;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : votingList
     */
    protected List<PersonToList> votingListPersonToList;

    /**
     * Nom de l'attribut en BD : vote
     */
    protected List<Vote> vote;

    /**
     * Nom de l'attribut en BD : personList
     */
    protected PersonList personList;

    /**
     * Nom de l'attribut en BD : userAccount
     */
    protected UserAccount userAccount;

    private static final long serialVersionUID = 3919883434867242596L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ACCOUNT_ID, String.class, accountId);
        visitor.visit(this, PROPERTY_VOTING_ID, String.class, votingId);
        visitor.visit(this, PROPERTY_EMAIL, String.class, email);
        visitor.visit(this, PROPERTY_VOTING_LIST_PERSON_TO_LIST, List.class, PersonToList.class, votingListPersonToList);
        visitor.visit(this, PROPERTY_VOTE, List.class, Vote.class, vote);
        visitor.visit(this, PROPERTY_PERSON_LIST, PersonList.class, personList);
        visitor.visit(this, PROPERTY_USER_ACCOUNT, UserAccount.class, userAccount);
        visitor.end(this);
    }

    @Override
    public void setAccountId(String accountId) {
        String oldValue = this.accountId;
        fireOnPreWrite(PROPERTY_ACCOUNT_ID, oldValue, accountId);
        this.accountId = accountId;
        fireOnPostWrite(PROPERTY_ACCOUNT_ID, oldValue, accountId);
    }

    @Override
    public String getAccountId() {
        fireOnPreRead(PROPERTY_ACCOUNT_ID, accountId);
        String result = this.accountId;
        fireOnPostRead(PROPERTY_ACCOUNT_ID, accountId);
        return result;
    }

    @Override
    public void setVotingId(String votingId) {
        String oldValue = this.votingId;
        fireOnPreWrite(PROPERTY_VOTING_ID, oldValue, votingId);
        this.votingId = votingId;
        fireOnPostWrite(PROPERTY_VOTING_ID, oldValue, votingId);
    }

    @Override
    public String getVotingId() {
        fireOnPreRead(PROPERTY_VOTING_ID, votingId);
        String result = this.votingId;
        fireOnPostRead(PROPERTY_VOTING_ID, votingId);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(PROPERTY_EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(PROPERTY_EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(PROPERTY_EMAIL, email);
        String result = this.email;
        fireOnPostRead(PROPERTY_EMAIL, email);
        return result;
    }

    @Override
    public void addVotingListPersonToList(PersonToList votingListPersonToList) {
        fireOnPreWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, null, votingListPersonToList);
        if (this.votingListPersonToList == null) {
            this.votingListPersonToList = new ArrayList<PersonToList>();
        }

        this.votingListPersonToList.add(votingListPersonToList);
        fireOnPostWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, this.votingListPersonToList.size(), null, votingListPersonToList);
    }

    @Override
    public void addAllVotingListPersonToList(List<PersonToList> votingListPersonToList) {
        if (votingListPersonToList == null) {
            return;
        }
        for (PersonToList item : votingListPersonToList) {
            addVotingListPersonToList(item);
        }
    }

    @Override
    public void setVotingListPersonToList(List<PersonToList> votingListPersonToList) {
        // Copy elements to keep data for fire with new reference
        List<PersonToList> oldValue = this.votingListPersonToList != null ? new ArrayList<PersonToList>(this.votingListPersonToList) : null;
        fireOnPreWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, oldValue, votingListPersonToList);
        this.votingListPersonToList = votingListPersonToList;
        fireOnPostWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, oldValue, votingListPersonToList);
    }

    @Override
    public void removeVotingListPersonToList(PersonToList votingListPersonToList) {
        fireOnPreWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, votingListPersonToList, null);
        if (this.votingListPersonToList == null || !this.votingListPersonToList.remove(votingListPersonToList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, this.votingListPersonToList.size() + 1, votingListPersonToList, null);
    }

    @Override
    public void clearVotingListPersonToList() {
        if (this.votingListPersonToList == null) {
            return;
        }
        for (PersonToList item : this.votingListPersonToList) {
        }
        List<PersonToList> oldValue = new ArrayList<PersonToList>(this.votingListPersonToList);
        fireOnPreWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, oldValue, this.votingListPersonToList);
        this.votingListPersonToList.clear();
        fireOnPostWrite(PROPERTY_VOTING_LIST_PERSON_TO_LIST, oldValue, this.votingListPersonToList);
    }

    @Override
    public List<PersonToList> getVotingListPersonToList() {
        return votingListPersonToList;
    }

    @Override
    public PersonToList getVotingListPersonToListByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(votingListPersonToList, topiaId);
    }

    @Override
    public PersonToList getVotingListPersonToList(VotingList votingList) {
        if (votingList == null || this.votingListPersonToList == null) {
            return null;
        }
        for (PersonToList item : this.votingListPersonToList) {
            if (votingList.equals(item.getVotingList())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizeVotingListPersonToList() {
        if (votingListPersonToList == null) {
            return 0;
        }
        return votingListPersonToList.size();
    }

    @Override
    public boolean isVotingListPersonToListEmpty() {
        int size = sizeVotingListPersonToList();
        return size == 0;
    }

    @Override
    public void addVote(Vote vote) {
        fireOnPreWrite(PROPERTY_VOTE, null, vote);
        if (this.vote == null) {
            this.vote = new ArrayList<Vote>();
        }

        vote.setPollAccount(this);

        this.vote.add(vote);
        fireOnPostWrite(PROPERTY_VOTE, this.vote.size(), null, vote);
    }

    @Override
    public void addAllVote(List<Vote> vote) {
        if (vote == null) {
            return;
        }
        for (Vote item : vote) {
            addVote(item);
        }
    }

    @Override
    public void setVote(List<Vote> vote) {
        // Copy elements to keep data for fire with new reference
        List<Vote> oldValue = this.vote != null ? new ArrayList<Vote>(this.vote) : null;
        fireOnPreWrite(PROPERTY_VOTE, oldValue, vote);
        this.vote = vote;
        fireOnPostWrite(PROPERTY_VOTE, oldValue, vote);
    }

    @Override
    public void removeVote(Vote vote) {
        fireOnPreWrite(PROPERTY_VOTE, vote, null);
        if (this.vote == null || !this.vote.remove(vote)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        vote.setPollAccount(null);

        fireOnPostWrite(PROPERTY_VOTE, this.vote.size() + 1, vote, null);
    }

    @Override
    public void clearVote() {
        if (this.vote == null) {
            return;
        }
        for (Vote item : this.vote) {
            item.setPollAccount(null);
        }
        List<Vote> oldValue = new ArrayList<Vote>(this.vote);
        fireOnPreWrite(PROPERTY_VOTE, oldValue, this.vote);
        this.vote.clear();
        fireOnPostWrite(PROPERTY_VOTE, oldValue, this.vote);
    }

    @Override
    public List<Vote> getVote() {
        return vote;
    }

    @Override
    public Vote getVoteByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(vote, topiaId);
    }

    @Override
    public int sizeVote() {
        if (vote == null) {
            return 0;
        }
        return vote.size();
    }

    @Override
    public boolean isVoteEmpty() {
        int size = sizeVote();
        return size == 0;
    }

    @Override
    public void setPersonList(PersonList personList) {
        PersonList oldValue = this.personList;
        fireOnPreWrite(PROPERTY_PERSON_LIST, oldValue, personList);
        this.personList = personList;
        fireOnPostWrite(PROPERTY_PERSON_LIST, oldValue, personList);
    }

    @Override
    public PersonList getPersonList() {
        fireOnPreRead(PROPERTY_PERSON_LIST, personList);
        PersonList result = this.personList;
        fireOnPostRead(PROPERTY_PERSON_LIST, personList);
        return result;
    }

    @Override
    public void setUserAccount(UserAccount userAccount) {
        UserAccount oldValue = this.userAccount;
        fireOnPreWrite(PROPERTY_USER_ACCOUNT, oldValue, userAccount);
        this.userAccount = userAccount;
        fireOnPostWrite(PROPERTY_USER_ACCOUNT, oldValue, userAccount);
    }

    @Override
    public UserAccount getUserAccount() {
        fireOnPreRead(PROPERTY_USER_ACCOUNT, userAccount);
        UserAccount result = this.userAccount;
        fireOnPostRead(PROPERTY_USER_ACCOUNT, userAccount);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<PersonToList> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(PersonToList.class);
            List<PersonToList> findAllByProperties = dao.findAllByProperties("pollAccount", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PollAccountAbstract
