package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PersonToListDAOAbstract<E extends PersonToList> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)PersonToList.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.PersonToList;
    }

    public E findByWeight(double v) throws TopiaException {
        E result = findByProperty(PersonToList.PROPERTY_WEIGHT, v);
        return result;
    }

    public List<E> findAllByWeight(double v) throws TopiaException {
        List<E> result = findAllByProperty(PersonToList.PROPERTY_WEIGHT, v);
        return result;
    }

    public E findByHasVoted(boolean v) throws TopiaException {
        E result = findByProperty(PersonToList.PROPERTY_HAS_VOTED, v);
        return result;
    }

    public List<E> findAllByHasVoted(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(PersonToList.PROPERTY_HAS_VOTED, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //PersonToListDAOAbstract<E extends PersonToList>
