/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: VoteDAOImpl.java 3215 2012-03-28 16:39:46Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/VoteDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;

public class VoteDAOImpl<E extends Vote> extends VoteDAOAbstract<E> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(VoteDAOImpl.class);

    public List<E> getVotesByPoll(Poll poll,
                                  TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(poll);
        Preconditions.checkNotNull(pager);

        List<E> results;

        // No need to load votes for an anonymous poll
        if (poll.isAnonymous()) {

            results = Lists.newArrayList();
        } else {

            // FIXME-FD20100309 : change model to suppress link from poll to vote
            // It's not necessary to have votes when retrieving the poll, this
            // method do this job only when it's needed

//        if (log.isDebugEnabled()) {
//            log.debug("Load votes for poll with uid = " + poll.getPollId());
//            log.debug("LIMIT : startIndex = " + startIndex + " _ " +
//                      "endIndex = " + endIndex);
//        }

            // FIXME : refactor this to use TopiaQuery from ToPIA 2.3
            // Order the results by creation date (the last vote done will be
            // at the end of the list)
            TopiaQuery query = createQuery("e").
                    addWhere("e.poll", TopiaQuery.Op.EQ, poll).
                    addOrder("topiaCreateDate");
            TopiaFilterPagerUtil.addPagerToQuery(query, pager);
            results = findAllByQuery(query);

//        
//        List<E> votes = find(
//                "FROM " + Vote.class.getName() +
//                " WHERE poll.pollId = :pollUId" +
//                " ORDER BY topiaCreateDate",
//                startIndex, endIndex,
//                new Object[]{"pollUId", poll.getPollId()});

//        if (log.isDebugEnabled()) {
//            log.debug("Nb votes found : " + votes.size());
//        }
//
//        results = Lists.newArrayList(results);
        }
        return results;
    }

    public boolean hasAlreadyVoted(String votingId, Poll poll) throws TopiaException {

        // Test using a count(*) on votes
        TopiaQuery query = createQuery("e").
                addWhere("e.poll", TopiaQuery.Op.EQ, poll).
                addWhere("e.pollAccount.votingId", TopiaQuery.Op.EQ, votingId).
                addOrder("topiaCreateDate");
        boolean result = existByQuery(query);
        return result;
//            List<Long> tmp = transaction.find(
//                    "SELECT COUNT(*)" +
//                    " FROM " + Vote.class.getName() +
//                    " WHERE poll.pollId = :pollUId" +
//                    " AND pollAccount.votingId = :votingId",
//                    "pollUId", poll.getPollId(),
//                    "votingId", votingId);
//
//            int count = tmp.get(0).intValue();
//
//            // If the count is greater than 0, there is an existing votingId
//            // who has already voted for the poll
//            result = count > 0;

    }
    
    public Vote findByAccountId(String accountId) throws TopiaException {
        
        String accountIdProperty = 
                TopiaQuery.getProperty("e", Vote.PROPERTY_POLL_ACCOUNT, PollAccount.PROPERTY_ACCOUNT_ID);

        TopiaQuery query = createQuery("e").addEquals(accountIdProperty, accountId);
        Vote result = findByQuery(query);
        return result;
    }
    
    
} //VoteDAOImpl<E extends Vote>
