/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.entities.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.chorem.pollen.entities.migration.PollenMigrationCallback;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaSQLQuery;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;

public class PollenMigrationCallbackV1_4
extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {
    public PollenMigrationCallbackV1_4(TopiaMigrationCallbackByClass callBack) {
        super(PollenMigrationCallback.V_1_4, callBack);
    }

    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        this.addIndexedChoices(tx, queries);
    }

    private void addIndexedChoices(TopiaContextImplementor tx, List<String> queries) throws TopiaException {
        queries.add("ALTER TABLE choice ADD COLUMN poll_idx INTEGER;");
        TopiaSQLQuery<String> getAllPollsQuery = new TopiaSQLQuery<String>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("select distinct(poll) from choice;");
                return ps;
            }

            protected String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        };
        List pollIds = getAllPollsQuery.findMultipleResult(tx);
        String choiceUpdate = "UPDATE choice SET poll_idx = %s WHERE topiaid = '%s';";
        for (String pollId : pollIds) {
            List choiceIds = new GetChoiceIdsSQLQuery(pollId).findMultipleResult(tx);
            int index = 0;
            for (String choiceId : choiceIds) {
                queries.add(String.format(choiceUpdate, index++, choiceId));
            }
        }
    }

    private static class GetChoiceIdsSQLQuery
    extends TopiaSQLQuery<String> {
        private final String pollId;

        public GetChoiceIdsSQLQuery(String pollId) {
            this.pollId = pollId;
        }

        protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
            PreparedStatement ps = connection.prepareStatement("SELECT topiaid FROM choice WHERE poll = ? ORDER BY topiacreatedate;");
            ps.setString(1, this.pollId);
            return ps;
        }

        protected String prepareResult(ResultSet set) throws SQLException {
            return set.getString(1);
        }
    }
}

