/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ResultDAOAbstract<E extends Result> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Result.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public E findByResultValue(String v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_RESULT_VALUE, v);
        return result;
    }

    public List<E> findAllByResultValue(String v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_RESULT_VALUE, v);
        return result;
    }

    public E findByByGroup(boolean v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_BY_GROUP, v);
        return result;
    }

    public List<E> findAllByByGroup(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_BY_GROUP, v);
        return result;
    }

    public E findByPoll(Poll v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_POLL, v);
        return result;
    }

    public List<E> findAllByPoll(Poll v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_POLL, v);
        return result;
    }

    public E findByVoteCountingType(VoteCountingType v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    public List<E> findAllByVoteCountingType(VoteCountingType v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsResult(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        return result;
    }

} //ResultDAOAbstract<E extends Result>
