/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PersonToListAbstract extends TopiaEntityAbstract implements PersonToList {

    /**
     * Nom de l'attribut en BD : weight
     */
    protected double weight;

    /**
     * Nom de l'attribut en BD : hasVoted
     */
    protected boolean hasVoted;

    /**
     * Nom de l'attribut en BD : votingList
     */
    protected VotingList votingList;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected PollAccount pollAccount;

    private static final long serialVersionUID = 3846416448183808821L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_WEIGHT, double.class, weight);
        visitor.visit(this, PROPERTY_HAS_VOTED, boolean.class, hasVoted);
        visitor.visit(this, PROPERTY_VOTING_LIST, VotingList.class, votingList);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public void setWeight(double weight) {
        double oldValue = this.weight;
        fireOnPreWrite(PROPERTY_WEIGHT, oldValue, weight);
        this.weight = weight;
        fireOnPostWrite(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public double getWeight() {
        fireOnPreRead(PROPERTY_WEIGHT, weight);
        double result = this.weight;
        fireOnPostRead(PROPERTY_WEIGHT, weight);
        return result;
    }

    @Override
    public void setHasVoted(boolean hasVoted) {
        boolean oldValue = this.hasVoted;
        fireOnPreWrite(PROPERTY_HAS_VOTED, oldValue, hasVoted);
        this.hasVoted = hasVoted;
        fireOnPostWrite(PROPERTY_HAS_VOTED, oldValue, hasVoted);
    }

    @Override
    public boolean isHasVoted() {
        fireOnPreRead(PROPERTY_HAS_VOTED, hasVoted);
        boolean result = this.hasVoted;
        fireOnPostRead(PROPERTY_HAS_VOTED, hasVoted);
        return result;
    }

    @Override
    public void setVotingList(VotingList votingList) {
        VotingList oldValue = this.votingList;
        fireOnPreWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
        this.votingList = votingList;
        fireOnPostWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
    }

    @Override
    public VotingList getVotingList() {
        fireOnPreRead(PROPERTY_VOTING_LIST, votingList);
        VotingList result = this.votingList;
        fireOnPostRead(PROPERTY_VOTING_LIST, votingList);
        return result;
    }

    @Override
    public void setPollAccount(PollAccount pollAccount) {
        PollAccount oldValue = this.pollAccount;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
        this.pollAccount = pollAccount;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
    }

    @Override
    public PollAccount getPollAccount() {
        fireOnPreRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        PollAccount result = this.pollAccount;
        fireOnPostRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PersonToListAbstract
