/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.JournalDTO;
import org.chorem.lima.service.JournalService;
import org.chorem.lima.service.neogia.AddJournalStub;
import org.chorem.lima.service.neogia.GetAllJournalStub;
import org.chorem.lima.service.neogia.RemoveJournalStub;
import org.chorem.lima.service.neogia.UpdateJournalStub;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.ofbiz.webservice.proxies.AddJournalDocument;
import org.ofbiz.webservice.proxies.GetAllJournalResponseDocument;
import org.ofbiz.webservice.proxies.RemoveJournalDocument;
import org.ofbiz.webservice.proxies.UpdateJournalDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionType;

public class NeogiaJournalService
implements JournalService {
    protected static final Log log = LogFactory.getLog(NeogiaJournalService.class);

    public String addJournal(JournalDTO journal) {
        try {
            AddJournalStub stub = new AddJournalStub();
            AddJournalDocument document = AddJournalDocument.Factory.newInstance();
            AddJournalDocument.AddJournal element = AddJournalDocument.AddJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            element.setDescription(journal.getDescription());
            element.setPrefix(journal.getPrefix());
            document.setAddJournal(element);
            stub.addJournal(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("journal " + journal.getIdName() + " added"));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't add a journal.", (Throwable)ex);
            return "error";
        }
    }

    public String updateJournal(JournalDTO journal) {
        try {
            UpdateJournalStub stub = new UpdateJournalStub();
            UpdateJournalDocument document = UpdateJournalDocument.Factory.newInstance();
            UpdateJournalDocument.UpdateJournal element = UpdateJournalDocument.UpdateJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            element.setDescription(journal.getDescription());
            element.setPrefix(journal.getPrefix());
            document.setUpdateJournal(element);
            stub.updateJournal(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("journal " + journal.getIdName() + " updated"));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't update a journal.", (Throwable)ex);
            return "error";
        }
    }

    public String removeJournal(JournalDTO journal) {
        try {
            RemoveJournalStub stub = new RemoveJournalStub();
            RemoveJournalDocument document = RemoveJournalDocument.Factory.newInstance();
            RemoveJournalDocument.RemoveJournal element = RemoveJournalDocument.RemoveJournal.Factory.newInstance();
            element.setIdName(journal.getIdName());
            document.setRemoveJournal(element);
            stub.removeJournal(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("journal " + journal.getIdName() + " removed "));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't remove a journal.", (Throwable)ex);
            return "error";
        }
    }

    public List<JournalDTO> getAllJournal() {
        LinkedList<JournalDTO> list = new LinkedList<JournalDTO>();
        try {
            GenericValueAcctgTransactionType[] array;
            GetAllJournalStub stub = new GetAllJournalStub();
            GetAllJournalResponseDocument response = stub.getAllJournal();
            for (GenericValueAcctgTransactionType value : array = response.getGetAllJournalResponse().getReturnArray()) {
                JournalDTO journal = NeogiaUtil.mapToJournalDTO(value);
                list.add(journal);
            }
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't get all journals.", (Throwable)ex);
        }
        return list;
    }
}

