/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.lima.service.neogia.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.ofbiz.webservice.wrappers.xsd.GenericValueNGlAccount;

/**
 *
 * @author ore
 */
public class NGLAccountToAccountDTO {

    /** log */
    private static final Log log = LogFactory.getLog(NGLAccountToAccountDTO.class);
    private static Map<String, AccountDTO> map;

    /**
     *
     */
    public NGLAccountToAccountDTO() {
        map = new HashMap<String, AccountDTO>();
    }

    /**
     * 
     * @param array
     * @return
     */
    public AccountDTO loadArray(GenericValueNGlAccount[] array) {
        // Root
        AccountDTO planComptable = new AccountDTO("0", "0", "Plan comptable", null, new LinkedList<AccountDTO>(), null);
        map.put("0", planComptable);
        // For all account
        for (GenericValueNGlAccount node : array) {
            String number = node.getAccount();
            String description = node.getDescription();
            String parentNumber = extractParentNumber(node.getTreePath());
            // New Account
            AccountDTO acc = new AccountDTO("0", number, description, null, new LinkedList<AccountDTO>(), null);
            map.put(number, acc);

            // Look for parent
            if (map.containsKey(parentNumber)) {
                AccountDTO parent = map.get(parentNumber);
                parent.addChild(acc);
            }
        }
        return map.get("0");
    }

    /**
     * 
     * @param treePath
     * @return
     */
    public static String extractParentNumber(String treePath) {
        /** Example of treePath : GL_STD_ROLLUP#355|35|3# **/
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(treePath);
        if (m.find()) {
            return m.group();
        } else {
            return "0";
        }
    }
}
