/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: RefcompCallBack.java 263 2012-02-09 13:10:48Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/constants/RefcompCallBack.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.nuiton.web.gwt.misc.LoaderNotification;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Default callback for refcomp service calls. Defines a default onFailure
 * method dealing with security exceptions
 *
 * User: couteau
 * Date: 30/12/10
 */
public abstract class RefcompCallBack<T> implements AsyncCallback<T>{

    @Override
    public void onFailure(Throwable caught) {

        LoaderNotification.closeLoader();

        RefcompMessages messages = GWT.create(RefcompMessages.class);

        if (caught.getClass().getName().contains("SecurityException")){
            Window.alert(messages.securityException());
            Logger logger = Logger.getLogger("");
            logger.log(Level.SEVERE, "An error occured",caught);
        } else {
            Window.alert(messages.exception());
            Logger logger = Logger.getLogger("");
            logger.log(Level.SEVERE, "An error occured",caught);
        }

    }

}
