/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: SkillsTableScreen.java 264 2012-02-20 16:07:24Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/agent/SkillsTableScreen.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.agent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.constants.*;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.*;
import fr.inra.refcomp.services.InvalidEntityException;
import org.nuiton.web.gwt.comparable.ComparableListBox;
import org.nuiton.web.gwt.misc.BlindedPopup;
import org.nuiton.web.gwt.misc.LoaderNotification;
import org.nuiton.web.gwt.table.DefaultTableModel;
import org.nuiton.web.gwt.table.SortableFlexTableWithModel;
import org.nuiton.web.gwt.table.SortableTableModel;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyAuthorisation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * User: couteau
 * Date: 31/12/10
 */
public class SkillsTableScreen extends Composite {

    public static int ROOT_SKILL_COL = 0;
    public static int TECH_SKILL_COL = 1;
    public static int TECH_SKILL_EDIT_COL = 2;
    public static int DOMAIN_SKILL_COL = 3;
    public static int DOMAIN_SKILL_EDIT_COL = 4;
    public static int FREQUENCY_COL = 5;
    public static int COMMENT_COL = 6;
    public static int RIGHT_COL = 7;
    public static int SHOW_PATH_COL = 8;
    public static int DELETE_SKILL_COL = 9;
    public static int DOMAIN_SKILL_ID_COL = 10;
    public static int TECH_SKILL_ID_COL = 11;
    public static int FREQUENCY_ID_COL = 12;
    public static int SKILL_ID_COL = 13;
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("SkillsTableScreen.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, SkillsTableScreen> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    protected List<Frequency> cachedFrequencies = new ArrayList<Frequency>();

    protected List<AgentSkill> skillsList = new ArrayList<AgentSkill>();

    @UiField
    SortableFlexTableWithModel skillsTable;

    @UiField
    InlineLabel agentName;

    @UiField
    Button addButton;

    @UiField
    Button cancelButton;

    @UiField
    Button saveButton;

    @UiField
    InlineLabel departmentName;

    @UiField
    InlineLabel catiName;

    @UiField
    InlineLabel unitsName;

    @UiField
    InlineLabel address;

    @UiField
    InlineLabel jobTypeRef;

    @UiField
    InlineLabel jobTypeName;

    @UiField
    InlineLabel pepiName;

    //@UiField
    //InlineLabel state;

    //@UiField
    //InlineLabel stateDate;

    //@UiField
    //InlineLabel refNumber;

    @UiField
    Anchor email;

    @UiField
    InlineLabel comment;

    @UiField
    HTMLPanel agentInfoPanel;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    HTMLPanel agentNamePanel;

    @UiField
    Label errorLabel;

    DefaultTableModel model;

    SortableTableModel sortableTableModel;

    SkillsTreeSelection techSkillSelect;

    SkillsCreation skillCreation;

    /**
     * Boolean to know if the screen is in edition state or only reading.
     */
    protected Boolean edition = false;

    /**
     * Manage the add button. Perform operation only when not in edition mode.
     * Button should not be visible otherwise.
     *
     * @param event the click event.
     */
    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {
        if (edition) {
            new BlindedPopup(skillCreation);
        }
    }

    void createSkill(Skill skill, String frequencyId) {
        LoaderNotification.openLoaderPanel();
        service.addSkill(skill, frequencyId, new RefcompCallBack<EntitiesList>() {
                @Override
                public void onSuccess(EntitiesList result) {

                    for (Map.Entry<BusinessEntity, Skill> entry : result.getEntities().entrySet()) {
                        AgentSkill skill = (AgentSkill) entry.getKey();
                        Skill root = entry.getValue();
                        skillsList.add(skill);
                        displayEditionSkill(skill, result, root);
                    }

                    skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                            SortableTableModel.ASC);

                    skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                            SortableTableModel.ASC);

                    setEditionMode();
                    LoaderNotification.closeLoader();
                }
            });
    }

    void createSkills(List<String> skillIds, String frequencyId) {
        LoaderNotification.openLoaderPanel();
        service.addSkill(skillIds, frequencyId, new RefcompCallBack<EntitiesList>() {
            @Override
            public void onSuccess(EntitiesList result) {

                for (Map.Entry<BusinessEntity, Skill> entry : result.getEntities().entrySet()) {
                    AgentSkill skill = (AgentSkill) entry.getKey();
                    Skill root = entry.getValue();
                    skillsList.add(skill);
                    displayEditionSkill(skill, result, root);
                }

                skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                        SortableTableModel.ASC);

                skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                        SortableTableModel.ASC);

                setEditionMode();
                LoaderNotification.closeLoader();
            }
        });
    }

    @UiHandler("saveButton")
    void doClickSave(ClickEvent event) {
        if (edition) {

            LoaderNotification.openLoaderPanel();

            errorPanel.setVisible(false);

            List<AgentSkill> skills = new ArrayList<AgentSkill>();

            //need to be final to be accessed in inner class
            final List<String> privateSkills = new ArrayList<String>();
            final List<String> publicSkills = new ArrayList<String>();

            for (int i = 0; i < model.getRowCount(); i++) {
                String id = (String) model.getValueAt(SKILL_ID_COL, i);
                AgentSkill editedSkill = getSkill(id);

                String technicalSkillId = (String) model.getValueAt(TECH_SKILL_ID_COL, i);
                ListBox frequencyBox = (ListBox)model.getValueAt(FREQUENCY_COL, i);
                String frequencyId = frequencyBox.getValue(frequencyBox.getSelectedIndex());
                TextArea commentBox = (TextArea)model.getValueAt(COMMENT_COL, i);
                String comment = commentBox.getText();

                editedSkill.setTechnicalSkill(technicalSkillId);
                editedSkill.setFrequency(frequencyId);
                editedSkill.setComment(comment);

                skills.add(editedSkill);

                ListBox rightsBox = (ListBox)model.getValueAt(RIGHT_COL, i);
                String right = rightsBox.getValue(rightsBox.getSelectedIndex());
                if (PRIVATE.equals(right)) {
                    privateSkills.add(id);
                } else {
                    publicSkills.add(id);
                }
            }

            //save everything
            service.saveMySkills(skills, new RefcompCallBack<EntitiesList>() {
                @Override
                public void onSuccess(EntitiesList result) {
                    service.setPrivateSkills(privateSkills,
                            new RefcompCallBack<Void>() {
                                @Override
                                public void onSuccess(Void result) {
                                    service.setPublicSkills(publicSkills,
                                            new RefcompCallBack<Void>() {
                                                @Override
                                                public void onSuccess(Void result) {
                                                    doClickCancel(null);
                                                }
                                            });
                                }
                            });

                    Map <BusinessEntity, Skill> entities = result.getEntities();
                    skillsList = new ArrayList<AgentSkill>();

                    for (Map.Entry<BusinessEntity, Skill> entry : entities.entrySet()) {
                        AgentSkill skill = (AgentSkill) entry.getKey();
                        skillsList.add(skill);
                    }

                    LoaderNotification.closeLoader();

                }

                @Override
                public void onFailure(Throwable caught) {
                    LoaderNotification.closeLoader();
                    if (caught instanceof InvalidEntityException) {
                        new BlindedPopup(new ErrorPanel(caught.getMessage()));
                    } else {
                        Menu.doClickLogout(null);
                    }
                }
            });
        }
    }

    @UiHandler("cancelButton")
    void doClickCancel(ClickEvent event) {
        if (edition) {
            errorPanel.setVisible(false);
            AgentUtil.checkAgent();
            initEditionMode();
        }
    }

    /**
     * Init the screen. If edition mode, the screen is initialized and filled in
     * with logged in user info. If reading mode, init the screen but let the
     * table empty as don't know which user to display.
     *
     * @param edition true for edition mode, false for reading
     */
    public SkillsTableScreen(Boolean edition) {

        this.edition = edition;

        if (edition) {
            AgentUtil.checkAgent();
        }


        initWidget(binder.createAndBindUi(SkillsTableScreen.this));

        init();

        if (edition) {
            initEditionMode();
        }

    }

    public SkillsTableScreen(final String agentId) {

        edition = false;

        initWidget(binder.createAndBindUi(SkillsTableScreen.this));

        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                RefComp.logOut();
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new Unauthorized());
                LoaderNotification.closeLoader();
            }

            @Override
            public void onSuccess(Boolean isLoggedIn) {
                
                
                if (!isLoggedIn) {
                    RefComp.logOut();
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                    LoaderNotification.closeLoader();
                } else {

                    init();

                    //Get the user name and display it
                    service.getAgentAndDependencies(agentId, new RefcompCallBack<EntitiesList>() {
                        @Override
                        public void onSuccess(EntitiesList result) {
                            

                            Map<BusinessEntity, Skill> entities = result.getEntities();

                            if (!entities.isEmpty()) {

                                Agent agent = null;

                                for (Map.Entry<BusinessEntity, Skill> entry : entities.entrySet()) {
                                    agent = (Agent) entry.getKey();
                                }

                                if (agent != null) {

                                    agentName.setText(agent.getFirstName() + " " + agent.getLastName());
                                    email.setHref("mailto:" + agent.getEmail());
                                    email.setText(agent.getEmail());
                                    pepiName.setText(agent.getPepi());
                                    address.setText(agent.getAddress());
                                    /*state.setText(agent.getState());

                                    DateTimeFormat format = DateTimeFormat.getFormat(
                                            DateTimeFormat.PredefinedFormat.DATE_SHORT);
                                    Date agentStateDate = agent.getStateDate();
                                    if (agentStateDate != null) {
                                        stateDate.setText(format.format(agentStateDate));
                                    }*/

//                    refNumber.setText(agent.getRefNumber());
                                    jobTypeRef.setText(agent.getJobTypeReference());
                                    jobTypeName.setText(agent.getJobType());
                                    comment.setText(agent.getComment());

                                    Department department = (Department) result.getDependency(agent.getDepartment());
                                    if (department != null) {
                                        String text = department.getName();
                                        String fullName = department.getFullName();
                                        if (fullName != null && !fullName.isEmpty()) {
                                            text += " - " + fullName;
                                        }
                                        departmentName.setText(text);
                                    }

                                    Cati cati = (Cati) result.getDependency(agent.getCati());
                                    if (cati != null) {
                                        String text = cati.getName();
                                        String fullName = cati.getFullName();
                                        if (fullName != null && !fullName.isEmpty()) {
                                            text += " - " + fullName;
                                        }
                                        catiName.setText(text);
                                    }

                                    Set<String> unitsIds = agent.getUnit();
                                    String units = "";
                                    for (String id : unitsIds) {
                                        Unit unit = (Unit) result.getDependency(id);
                                        if (unit != null) {
                                            String text = unit.getName();
                                            String fullName = unit.getFullName();
                                            if (fullName != null && !fullName.isEmpty()) {
                                                text += " - " + fullName;
                                            }
                                            units += ", " + text;
                                            if (address.getText().equals("")) {
                                                address.setText(unit.getAddress());
                                            }
                                        }
                                    }
                                    if (!units.isEmpty()) {
                                        units = units.substring(1);
                                    }
                                    unitsName.setText(units);
                                }
                            }
                        }
                    });

                    //Get the skills of the logged in user and display them
                    AsyncCallback<EntitiesList> callback = new RefcompCallBack<EntitiesList>() {
                        public void onSuccess(EntitiesList result) {
                            initTable();

                            Map<BusinessEntity, Skill> entities = result.getEntities();

                            skillsList = new ArrayList<AgentSkill>();

                            for (Map.Entry<BusinessEntity, Skill> entry : entities.entrySet()) {
                                AgentSkill skill = (AgentSkill) entry.getKey();
                                Skill root = entry.getValue();
                                skillsList.add(skill);
                                displayReadingSkill(skill, result, root);
                            }


                            initTableModel();

                            skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                                    SortableTableModel.ASC);

                            LoaderNotification.closeLoader();

                            setReadingMode();
                        }
                    };

                    service.getSkills(agentId, callback);
                }
            }
        });
    }

    public void initEditionMode(){

        techSkillSelect = new SkillsTreeSelection(
                SkillsTableScreen.this, 0, true);

        skillCreation = new SkillsCreation(
                SkillsTableScreen.this);

        agentNamePanel.setVisible(false);

        //Get the skills of the logged in user and display them
        AsyncCallback<EntitiesList> callback = new RefcompCallBack<EntitiesList>() {
            public void onSuccess(EntitiesList result) {

                initTable();

                if (result == null) {
                    return;
                }
                
                Map<BusinessEntity, Skill> entities = result.getEntities();

                skillsList = new ArrayList<AgentSkill>();

                for (Map.Entry<BusinessEntity, Skill> entry : entities.entrySet()) {
                    AgentSkill skill = (AgentSkill) entry.getKey();
                    Skill root = entry.getValue();
                    skillsList.add(skill);
                    displayEditionSkill(skill, result, root);
                }

                initTableModel();

                skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                        SortableTableModel.ASC);
                
                setEditionMode();

                LoaderNotification.closeLoader();
            }
        };

        service.getSkills(callback);
    }

    /**
     * Add a skill in edition mode
     * @param skill the skill to add
     * @param dependencies the EntitiesList containing the dependencies
     */
    protected void displayEditionSkill(AgentSkill skill,
                                       EntitiesList dependencies,
                                       Skill root) {

        final int rowCount = model.getRowCount();

        int columnCount = model.getColumnCount();

        Object[] row = new Object[columnCount];

        //Root
        if (root != null) {
            row[ROOT_SKILL_COL] = root.getName();
        }

        //Tech skill
        Skill techSkill = (Skill) dependencies.getDependency(
                skill.getTechnicalSkill());
        if (techSkill != null) {
            row[TECH_SKILL_COL] = techSkill.getName();
            row[TECH_SKILL_ID_COL] = techSkill.getWikittyId();
        } else {
            row[TECH_SKILL_COL] = "";
            row[ROOT_SKILL_COL] = "";
        }

        //Edit tech skill button
        IdButton editTechnicalSkillButton = new IdButton(messages.modify(),
                skill.getWikittyId());
        editTechnicalSkillButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                techSkillSelect.setRow(rowCount);
                new BlindedPopup(techSkillSelect);
            }
        });
        editTechnicalSkillButton.setStyleName(CSS.EDIT);
        row[TECH_SKILL_EDIT_COL] = editTechnicalSkillButton;

        //Frequency
        ComparableListBox frequencyBox = new ComparableListBox();
        frequencyBox.setStyleName(CSS.FREQUENCYBOX);
        for (Frequency freq : cachedFrequencies) {
            frequencyBox.addItem(freq.getName(), freq.getWikittyId());
        }
        for (int i = 0; i < frequencyBox.getItemCount(); i++) {
            String value = frequencyBox.getValue(i);
            if (value.equals(skill.getFrequency())) {
                frequencyBox.setSelectedIndex(i);
            }
        }
        row[FREQUENCY_COL] = frequencyBox;
        row[FREQUENCY_ID_COL] = skill.getFrequency();

        //right
        WikittyAuthorisation right = (WikittyAuthorisation) dependencies.getDependency(skill.getWikittyId());
        String rightString = PUBLIC;
        if (right != null && right.getReader() != null && !right.getReader().isEmpty()) {
            rightString = PRIVATE;
        }
        ComparableListBox rightsBox = new ComparableListBox();
        rightsBox.addItem(messages.publicRight(), PUBLIC);
        rightsBox.addItem(messages.privateRight(), PRIVATE);
        rightsBox.setTitle(messages.rightsTooltip());
        for (int i = 0; i < rightsBox.getItemCount(); i++) {
            String value = rightsBox.getValue(i);
            if (value.equals(rightString)) {
                rightsBox.setSelectedIndex(i);
            }
        }
        row[RIGHT_COL] = rightsBox;

        //comment
        TextArea commentBox = new TextArea();
        commentBox.setText(skill.getComment());
        commentBox.setVisibleLines(3);
        row[COMMENT_COL] = commentBox;

        //Delete button
        IdButton deleteSkillButton = new IdButton(messages.delete(),
                skill.getWikittyId());
        deleteSkillButton.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {

                Boolean validate = Window.confirm(messages.sure());

                if (validate) {

                    final String id = ((IdButton) event.getSource()).getId();

                    service.removeSkill(id, new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            removeSkill(id);
                        }
                    });
                }
            }
        });
        deleteSkillButton.setStyleName(CSS.SUPP);
        deleteSkillButton.setTitle(messages.deleteTooltip());
        row[DELETE_SKILL_COL] = deleteSkillButton;

        //Id
        row[SKILL_ID_COL] = skill.getWikittyId();

        //pathButton
        IdButton pathButton = new IdButton(messages.path(),
                skill.getTechnicalSkill());
        pathButton.setTitle(messages.pathTooltip());
        pathButton.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {

                final String id = ((IdButton) event.getSource()).getId();

                service.getPath(id, new RefcompCallBack<String>() {
                    @Override
                    public void onSuccess(String result) {
                        new BlindedPopup(new PathPanel(result));
                    }
                });
            }
        });
        pathButton.setStyleName(CSS.PATH);
        row[SHOW_PATH_COL] = pathButton;

        model.addRow(row);
    }

    /**
     * Add a skill in reading mode
     * @param skill the skill to add
     * @param dependencies the dependencies for displaying
     */
    protected void displayReadingSkill(AgentSkill skill,
                                       EntitiesList dependencies,
                                       Skill root) {

        int columnCount = model.getColumnCount();

        Object[] row = new Object[columnCount];

        //Root
        if (root != null) {
            row[ROOT_SKILL_COL] = root.getName();
        }

        //Tech skill
        Skill techSkill = (Skill) dependencies.getDependency(
                skill.getTechnicalSkill());
        if (techSkill != null) {
            row[TECH_SKILL_COL] = techSkill.getName();
            row[TECH_SKILL_ID_COL] = techSkill.getWikittyId();
        }

        //Domain skill
        //Useless now, commented so that it can be re-activated easily jcouteau 22/01/2011
        /*Skill domainSkill = (Skill) dependencies.getDependency(
                skill.getDomainSkill());
        if (domainSkill != null) {
            model.setValueAt(domainSkill.getName(), rowCount, DOMAIN_SKILL_COL);
        }*/

        //Frequency
        Frequency frequency = (Frequency) dependencies.getDependency(
                skill.getFrequency());
        if (frequency != null) {
            row[FREQUENCY_COL] = frequency.getName();
        }

        //comment
        String comment = skill.getComment();
        if (comment == null || comment.isEmpty()) {
            //Put empty string or there will be no td rendered in tree
            row[COMMENT_COL] = "&nbsp;";
        } else {
            row[COMMENT_COL] = comment;
        }

        model.addRow(row);

        //Show/hide the proper columns
        setReadingMode();

    }

    /**
     * Display/Hide the right columns for edition mode
     */
    protected void setEditionMode() {
        skillsTable.setColumnVisible(TECH_SKILL_ID_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_ID_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_EDIT_COL, false);
        skillsTable.setColumnVisible(SKILL_ID_COL, false);
        skillsTable.setColumnVisible(FREQUENCY_ID_COL, false);

        addButton.setVisible(true);
        cancelButton.setVisible(true);
        saveButton.setVisible(true);
        agentInfoPanel.setVisible(false);


        skillsTable.getRowFormatter().addStyleName(0, CSS.TABLE_HEADER);

        HTMLTable.CellFormatter cells = skillsTable.getCellFormatter();
        for(int i = 0; i < skillsTable.getRowCount(); i++) {
            for (int j = 0; j < skillsTable.getCellCount(i); j++) {
                if (i == 0) {
                    if (j == DELETE_SKILL_COL || j == TECH_SKILL_EDIT_COL || j == SHOW_PATH_COL) {
                        //do nothing
                    } else {
                        cells.setStyleName(i, j, CSS.SORTABLE);
                    }
                } else {
                    if (j == TECH_SKILL_COL || j == TECH_SKILL_EDIT_COL || j == COMMENT_COL) {
                        cells.setStyleName(i, j, CSS.FDGREY_DASHED);
                    } else {
                        cells.setStyleName(i, j, CSS.DASHED);
                    }
                }
            }
        }
    }

    /**
     * Display/hide the right columns for reading mode
     */
    protected void setReadingMode(){
        skillsTable.setColumnVisible(TECH_SKILL_ID_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_ID_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_COL, false);
        skillsTable.setColumnVisible(SKILL_ID_COL, false);
        skillsTable.setColumnVisible(DOMAIN_SKILL_EDIT_COL, false);
        skillsTable.setColumnVisible(TECH_SKILL_EDIT_COL, false);
        skillsTable.setColumnVisible(FREQUENCY_ID_COL, false);
        skillsTable.setColumnVisible(RIGHT_COL, false);
        skillsTable.setColumnVisible(SHOW_PATH_COL, false);
        skillsTable.setColumnVisible(DELETE_SKILL_COL, false);

        addButton.setVisible(false);
        cancelButton.setVisible(false);
        saveButton.setVisible(false);
        agentInfoPanel.setVisible(true);

        skillsTable.getRowFormatter().addStyleName(0, CSS.TABLE_HEADER);

        HTMLTable.CellFormatter cells = skillsTable.getCellFormatter();
        for (int i = 0; i < skillsTable.getRowCount(); i++) {
            for (int j = 0; j < skillsTable.getCellCount(i); j++) {
                if (i == 0) {
                    if (j == DELETE_SKILL_COL || j == TECH_SKILL_EDIT_COL || j == SHOW_PATH_COL) {
                        //do nothing
                    } else {
                        cells.setStyleName(i, j, CSS.SORTABLE);
                    }
                } else {
                    if (j == TECH_SKILL_COL || j == TECH_SKILL_EDIT_COL || j == COMMENT_COL) {
                        cells.setStyleName(i, j, CSS.FDGREY_DASHED);
                    } else {
                        cells.setStyleName(i, j, CSS.DASHED);
                    }
                }
            }
        }
    }

    /**
     * Init the table with column headers
     */
    protected void initTable() {
        skillsTable.clear(true);

        Object[][] data = new Object[][]{};

        String[] columnNames = new String[]{
                messages.rootSkill(),
                messages.skill(),
                " ",
                messages.linkedSkill(),
                " ",
                messages.frequency(),
                messages.comment(),
                messages.right(),
                " ",
                " ",
                "wikittyId",
                "mainSkillId",
                "secondSkillId",
                "frequencyId"
        };

        model = new DefaultTableModel(data, columnNames);

        sortableTableModel = new SortableTableModel(model);
    }

    public void initTableModel() {

        skillsTable.setModel(sortableTableModel);

        skillsTable.setText(0, ROOT_SKILL_COL, messages.rootSkill());
        skillsTable.setText(0, TECH_SKILL_COL, messages.skill());
        skillsTable.setText(0, DOMAIN_SKILL_COL, messages.linkedSkill());
        skillsTable.setText(0, FREQUENCY_COL, messages.frequency());
        skillsTable.setText(0, COMMENT_COL, messages.comment());
        skillsTable.setText(0, SKILL_ID_COL, "wikittyId");
        skillsTable.setText(0, TECH_SKILL_ID_COL, "mainSkillId");
        skillsTable.setText(0, DOMAIN_SKILL_ID_COL, "secondSkillId");
        skillsTable.setText(0, RIGHT_COL, messages.right());
    }

    /**
     * Init the Composite and the frequencies cache
     */
    protected void init() {

        //init the cached frequencies
        service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
            @Override
            public void onSuccess(List<Frequency> result) {
                cachedFrequencies = result;
            }
        });

        errorPanel.setVisible(false);
    }

    protected void setTechnicalSkill(int row, Skill skill){
        if (skill != null) {

            model.setValueAt(skill.getWikittyId(),row, TECH_SKILL_ID_COL);
            model.setValueAt(skill.getName(),row, TECH_SKILL_COL);

            IdButton button = (IdButton)model.getValueAt(SHOW_PATH_COL, row);
            button.setId(skill.getWikittyId());
        }
    }

    protected void removeSkill(String skillId) {
        for(int i=0;i< model.getRowCount();i++){
            String id = (String) model.getValueAt(SKILL_ID_COL, i);
            if (skillId.equals(id)) {
                model.removeRow(i);
            }
        }
    }

    protected AgentSkill getSkill(String id) {
        for (AgentSkill skill : skillsList) {
            if (id.equals(skill.getWikittyId())){
                return skill;
            }
        }
        return null;
    }

    /**
     * Method to get the root skill when editing its skills
     * @param row the row edited
     * @param skillId the skill to get the root of
     */
    protected void setRootSkill(final int row, final String skillId) {
        List<String> skills = new ArrayList<String>();
        skills.add(skillId);
        service.getRootSkill(skills, new RefcompCallBack<Map<String, Skill>>() {
            @Override
            public void onSuccess(Map<String, Skill> result) {

                model.setValueAt(result.get(skillId).getName(), row, ROOT_SKILL_COL);

                skillsTable.getModel().setSortedColumn(ROOT_SKILL_COL,
                        SortableTableModel.ASC);
            }
        });
    }

    /**
     * Button that know the id of the skill it is referring
     */
    protected class IdButton extends Button {

        protected String id;

        public IdButton(String title, String id) {
            super(title);
            this.id = id;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

    }

}
