/*
 * Decompiled with CFR 0.152.
 */
package winstone.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateKeySpec;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;
import winstone.HostGroup;
import winstone.HttpListener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.auth.BasicAuthenticationHandler;

public class HttpsListener
extends HttpListener {
    private static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.ssl.LocalStrings");
    private final KeyStore keystore;
    private final char[] password;
    private final String keyManagerType;
    private boolean performClientAuth;

    public HttpsListener(Map args, ObjectPool objectPool, HostGroup hostGroup) throws IOException {
        super(args, objectPool, hostGroup);
        try {
            this.performClientAuth = WebAppConfiguration.booleanArg(args, this.getConnectorName() + "VerifyClient", false);
            String opensslCert = WebAppConfiguration.stringArg(args, this.getConnectorName() + "Certificate", null);
            String opensslKey = WebAppConfiguration.stringArg(args, this.getConnectorName() + "PrivateKey", null);
            String keyStore = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyStore", null);
            String pwd = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyStorePassword", null);
            if (opensslCert != null ^ opensslKey != null) {
                throw new WinstoneException(MessageFormat.format("--{0}Certificate and --{0}PrivateKey need to be used together", this.getConnectorName()));
            }
            if (keyStore != null && opensslKey != null) {
                throw new WinstoneException(MessageFormat.format("--{0}Certificate and --{0}KeyStore are mutually exclusive", this.getConnectorName()));
            }
            if (keyStore != null) {
                File ksFile = new File(keyStore);
                if (!ksFile.exists() || !ksFile.isFile()) {
                    throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", ksFile.getPath()));
                }
                this.password = pwd != null ? pwd.toCharArray() : null;
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(new FileInputStream(ksFile), this.password);
            } else if (opensslCert != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                Certificate cert = cf.generateCertificate(new FileInputStream(opensslCert));
                PrivateKey key = HttpsListener.readPEMRSAPrivateKey(new FileReader(opensslKey));
                this.password = "changeit".toCharArray();
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(null);
                this.keystore.setKeyEntry("hudson", key, this.password, new Certificate[]{cert});
            } else {
                this.password = "changeit".toCharArray();
                System.out.println("Using one-time self-signed certificate");
                CertAndKeyGen ckg = new CertAndKeyGen("RSA", "SHA1WithRSA", null);
                ckg.generate(1024);
                PrivateKey privKey = ckg.getPrivateKey();
                X500Name xn = new X500Name("Test site", "Unknown", "Unknown", "Unknown");
                X509Certificate cert = ckg.getSelfCertificate(xn, 315360000L);
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(null);
                this.keystore.setKeyEntry("hudson", privKey, this.password, new Certificate[]{cert});
            }
        }
        catch (GeneralSecurityException e) {
            throw (IOException)new IOException("Failed to handle keys").initCause(e);
        }
        this.keyManagerType = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyManagerType", "SunX509");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPEMRSAPrivateKey(Reader reader) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String line;
            BufferedReader r = new BufferedReader(reader);
            boolean in = false;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("-----")) {
                    in = !in;
                    continue;
                }
                if (!in) continue;
                char[] inBytes = line.toCharArray();
                byte[] outBytes = new byte[inBytes.length * 3 / 4];
                int length = BasicAuthenticationHandler.decodeBase64(inBytes, outBytes, 0, inBytes.length, 0);
                baos.write(outBytes, 0, length);
            }
        }
        finally {
            reader.close();
        }
        DerInputStream dis = new DerInputStream(baos.toByteArray());
        DerValue[] seq = dis.getSequence(0);
        BigInteger mod = seq[1].getBigInteger();
        BigInteger privExpo = seq[3].getBigInteger();
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(new RSAPrivateKeySpec(mod, privExpo));
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected String getConnectorScheme() {
        return "https";
    }

    protected ServerSocket getServerSocket() throws IOException {
        SSLContext context = this.getSSLContext();
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        SSLServerSocket ss = (SSLServerSocket)(this.listenAddress == null ? factory.createServerSocket(this.listenPort, HttpListener.BACKLOG_COUNT) : factory.createServerSocket(this.listenPort, HttpListener.BACKLOG_COUNT, InetAddress.getByName(this.listenAddress)));
        ss.setEnableSessionCreation(true);
        if (this.performClientAuth) {
            ss.setNeedClientAuth(true);
        }
        return ss;
    }

    protected void parseSocketInfo(Socket socket, WinstoneRequest req) throws IOException {
        super.parseSocketInfo(socket, req);
        if (socket instanceof SSLSocket) {
            SSLSocket s = (SSLSocket)socket;
            SSLSession ss = s.getSession();
            if (ss != null) {
                Certificate[] certChain = null;
                try {
                    certChain = ss.getPeerCertificates();
                }
                catch (Throwable err) {
                    // empty catch block
                }
                if (certChain != null) {
                    req.setAttribute("javax.servlet.request.X509Certificate", certChain);
                    req.setAttribute("javax.servlet.request.cipher_suite", ss.getCipherSuite());
                    req.setAttribute("javax.servlet.request.ssl_session", new String(ss.getId()));
                    req.setAttribute("javax.servlet.request.key_size", this.getKeySize(ss.getCipherSuite()));
                }
            }
            req.setIsSecure(true);
        }
    }

    private Integer getKeySize(String cipherSuite) {
        if (cipherSuite.indexOf("_WITH_NULL_") != -1) {
            return new Integer(0);
        }
        if (cipherSuite.indexOf("_WITH_IDEA_CBC_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_RC2_CBC_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_128_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_DES40_CBC_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_DES_CBC_") != -1) {
            return new Integer(56);
        }
        if (cipherSuite.indexOf("_WITH_3DES_EDE_CBC_") != -1) {
            return new Integer(168);
        }
        return null;
    }

    public SSLContext getSSLContext() throws IOException {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keyManagerType);
            kmf.init(this.keystore, this.password);
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", this.keystore.size() + "");
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", new String[]{alias, this.keystore.getCertificate(alias) + ""});
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(kmf.getKeyManagers(), null, null);
            return context;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

