/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterValues;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceBoat;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class BoatFilterComponent extends FilterComponent<BoatFilter> {

    @SessionState
    @Property
    private ConnectedUser connectedUser;

    @InjectComponent
    private FeedBack filterFeedback;

    @Inject
    private ServiceBoat serviceBoat;

    /*
     * Datas
     */
    @Persist
    private BoatFilterValues possibleValuesForFilter;

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public void resetFilter() {
        setFilter(serviceBoat.newBoatFilter(getUser()));
    }

    @Override
    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }

    public BoatFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public BoatFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected BoatFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceBoat.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    public String[] getShipOwnerNamesContains(String input) {
        List<String> results = serviceBoat.getShipOwnerNamesContains(input);
        return results.toArray(new String[results.size()]);
    }

    public String[] getBoatNamesStartWith(String input) {
        List<String> results = serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }

    public void setSampleRow(SampleRow sampleRow) {
        getFilter().getSamplingFilter().setSampleRow(sampleRow);
    }

    public String[] onProvideCompletionsFromShipOwnerName(String input) {
        return getShipOwnerNamesContains(input);
    }

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        return getBoatNamesStartWith(input);
    }

    public List<SampleRow> getSampleRows() {
        // On ne propose pas à l'utilisateur tout, on filtre pour qu'il ne puisse
        // voir que les lignes de son programme (sécu) et uniquement les lignes
        // dont le programme n'est pas terminé
        List<SampleRow> sampleRows = new LinkedList<SampleRow>();
        for (SampleRow sampleRow : getPossibleValuesForFilter().getSamplingFilterValues().getSampleRows()) {
            ObsProgram obsProgram = connectedUser.getProfile().getObsProgram();
            boolean addSampleRow = sampleRow.getObsProgram().equals(obsProgram);
            if (obsProgram != ObsProgram.OBSDEB) {
                addSampleRow &= sampleRow.getPeriodEnd().after(new Date());
            }
            if (addSampleRow) {
                sampleRows.add(sampleRow);
            }
        }
        return sampleRows;
    }
}
