/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import winstone.Launcher;
import winstone.WinstoneResourceBundle;

public class Logger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String DEFAULT_STREAM = "Winstone";
    public static int MIN = 1;
    public static int ERROR = 2;
    public static int WARNING = 3;
    public static int INFO = 5;
    public static int SPEED = 6;
    public static int DEBUG = 7;
    public static int FULL_DEBUG = 8;
    public static int MAX = 9;
    protected static Boolean semaphore = new Boolean(true);
    protected static boolean initialised = false;
    protected static Writer defaultStream;
    protected static Map namedStreams;
    protected static int currentDebugLevel;
    protected static final DateFormat sdfLog;
    protected static boolean showThrowingThread;

    public static void init(int level) {
        Logger.init(level, System.out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(int level, OutputStream defaultStream, boolean showThrowingThreadArg) {
        Boolean bl = semaphore;
        synchronized (bl) {
            if (!initialised) {
                initialised = false;
                currentDebugLevel = level;
                namedStreams = new HashMap();
                initialised = true;
                Logger.setStream(DEFAULT_STREAM, defaultStream);
                showThrowingThread = showThrowingThreadArg;
            }
        }
    }

    public static void setStream(String name, OutputStream stream) {
        Logger.setStream(name, stream != null ? new OutputStreamWriter(stream) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStream(String name, Writer stream) {
        if (name == null) {
            name = DEFAULT_STREAM;
        }
        if (!initialised) {
            Logger.init(INFO);
        }
        Boolean bl = semaphore;
        synchronized (bl) {
            if (name.equals(DEFAULT_STREAM)) {
                defaultStream = stream;
            } else if (stream == null) {
                namedStreams.remove(name);
            } else {
                namedStreams.put(name, stream);
            }
        }
    }

    public static void flush(String name) {
        Writer stream;
        if (!initialised) {
            Logger.init(INFO);
        }
        if ((stream = Logger.getStreamByName(name)) != null) {
            try {
                stream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Writer getStreamByName(String streamName) {
        if (streamName != null && streamName.equals(DEFAULT_STREAM)) {
            Boolean bl = semaphore;
            synchronized (bl) {
                Writer stream = (Writer)namedStreams.get(streamName);
                if (stream == null && !namedStreams.containsKey(streamName)) {
                    stream = defaultStream;
                }
                return stream;
            }
        }
        return defaultStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentDebugLevel(int level) {
        if (!initialised) {
            Logger.init(level);
        } else {
            Boolean bl = semaphore;
            synchronized (bl) {
                currentDebugLevel = level;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logInternal(String streamName, String message, Throwable error) {
        Writer stream;
        if (!initialised) {
            Logger.init(INFO);
        }
        if ((stream = Logger.getStreamByName(streamName)) != null) {
            StringWriter fullMessage = new StringWriter();
            String date = null;
            DateFormat dateFormat = sdfLog;
            synchronized (dateFormat) {
                date = sdfLog.format(new Date());
            }
            try {
                ((Writer)fullMessage).write("[");
                ((Writer)fullMessage).write(streamName);
                ((Writer)fullMessage).write(" ");
                ((Writer)fullMessage).write(date);
                ((Writer)fullMessage).write("] - ");
                if (showThrowingThread) {
                    ((Writer)fullMessage).write("[");
                    ((Writer)fullMessage).write(Thread.currentThread().getName());
                    ((Writer)fullMessage).write("] - ");
                }
                ((Writer)fullMessage).write(message);
                if (error != null) {
                    ((Writer)fullMessage).write(LINE_SEPARATOR);
                    PrintWriter pw = new PrintWriter(fullMessage);
                    error.printStackTrace(pw);
                    pw.flush();
                }
                ((Writer)fullMessage).write(LINE_SEPARATOR);
                stream.write(((Object)fullMessage).toString());
                stream.flush();
            }
            catch (IOException err) {
                System.err.println(Launcher.RESOURCES.getString("Logger.StreamWriteError", message));
                err.printStackTrace(System.err);
            }
        }
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey), null);
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey, Throwable error) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey), error);
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey, String param) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey, param), null);
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey, String[] params) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey, params), null);
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey, String param, Throwable error) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey, param), error);
    }

    public static void log(int level, WinstoneResourceBundle resources, String messageKey, String[] params, Throwable error) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(DEFAULT_STREAM, resources.getString(messageKey, params), error);
    }

    public static void log(int level, WinstoneResourceBundle resources, String streamName, String messageKey, String[] params, Throwable error) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(streamName, resources.getString(messageKey, params), error);
    }

    public static void logDirectMessage(int level, String streamName, String message, Throwable error) {
        if (currentDebugLevel < level) {
            return;
        }
        Logger.logInternal(streamName, message, error);
    }

    static {
        sdfLog = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }
}

