/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.bean.ObservationType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry5.EventContext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/** Instances of this class represent the context given in a Tapestry page.
 *
 * The purpose of this class is to be used in onActive() event in Tapestry a
 * tapestry page. By given the EventContext object injected by Tapestry, to
 * an instance of this class, you will be able to understand what context is.
 *
 * Another use of this class is to create in instance and fill it with values
 * in order to create a context to create a link to a page.
 *
 * In Tapestry, context is stored in the URL. For example, given an URL ending
 * by
 *
 * <pre>
 * sampleRowCode/2011_023/observationTypeName/PHONE_CALL
 * </pre>
 *
 * This object will allow you to do getSampleRowCode() (return "2011_023") and
 * getObservationType (will return ObservationType.PHONE_CALL).
 *
 */
public class WaoActivationContext {

    protected static final String SAMPLE_ROW_CODE = "sampleRowCode";
    protected static final String SAMPLE_ROW_ID = "sampleRowId";
    protected static final String OBSERVATION_TYPE_NAME = "observationTypeName";
    protected static final String BOAT_IMMATRICULATION = "boatImmatriculation";
    protected static final String SHIP_OWNER_NAME = "shipOwnerName";

    protected static final List<String> VALID_KEYS = Arrays.asList(
            SAMPLE_ROW_CODE, SAMPLE_ROW_ID, OBSERVATION_TYPE_NAME,
            BOAT_IMMATRICULATION, SHIP_OWNER_NAME);

    protected String sampleRowCode;
    protected String sampleRowId;
    protected ObservationType observationType;
    protected Integer boatImmatriculation;
    protected String shipOwnerName;

    public static WaoActivationContext newEmptyContext() {
        WaoActivationContext newWaoActivationContext = new WaoActivationContext();
        return newWaoActivationContext;
    }

    public static WaoActivationContext newContextFromTapestry(
            EventContext tapestryContext) {
        WaoActivationContext newWaoActivationContext =
                                                new WaoActivationContext();
        String[] strings = tapestryContext.toStrings();
        Map<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < strings.length;) {
            String key = strings[i++];
            if ( ! VALID_KEYS.contains(key) ) {
                throw new IllegalArgumentException("'" + key + "' is not a " +
                                                   "valid key");
            }
            String value = strings[i++];
            context.put(key, value);
        }
        newWaoActivationContext.setSampleRowCode(context.get(SAMPLE_ROW_CODE));
        newWaoActivationContext.setObservationType(context.get(OBSERVATION_TYPE_NAME));
        newWaoActivationContext.setSampleRowId(context.get(SAMPLE_ROW_ID));
        newWaoActivationContext.setBoatImmatriculation(context.get(BOAT_IMMATRICULATION));
        newWaoActivationContext.setShipOwnerName(context.get(SHIP_OWNER_NAME));
        return newWaoActivationContext;
    }

    @Override
    public String toString() {
        String toString = ToStringBuilder.reflectionToString(this);
        return toString;
    }

    public String[] toStrings() {
        Map<String, String> context = new TreeMap<String, String>();
        if (sampleRowCode != null) {
            context.put(SAMPLE_ROW_CODE, sampleRowCode);
        }
        if (sampleRowId != null) {
            context.put(SAMPLE_ROW_ID, sampleRowId);
        }
        if (observationType != null) {
            context.put(OBSERVATION_TYPE_NAME, observationType.name());
        }
        if (boatImmatriculation != null) {
            context.put(BOAT_IMMATRICULATION,
                        String.valueOf(boatImmatriculation));
        }
        if (shipOwnerName != null) {
            context.put(SHIP_OWNER_NAME, shipOwnerName);
        }
        String[] strings = new String[context.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> contextEntry : context.entrySet()) {
            strings[i++] = contextEntry.getKey();
            strings[i++] = contextEntry.getValue();
        }
        return strings;
    }

    protected void setObservationType(String name) {
        if (name != null) {
            setObservationType(ObservationType.valueOf(name));
        }
    }

    public String getSampleRowCode() {
        return sampleRowCode;
    }

    public void setSampleRowCode(String sampleRowCode) {
        this.sampleRowCode = sampleRowCode;
    }

    public String getSampleRowId() {
        return sampleRowId;
    }

    public void setSampleRowId(String sampleRowId) {
        this.sampleRowId = sampleRowId;
    }

    public ObservationType getObservationType() {
        return observationType;
    }

    public void setObservationType(ObservationType observationType) {
        this.observationType = observationType;
    }

    public void setBoatImmatriculation(String boatImmatriculation) {
        if (boatImmatriculation == null) {
            this.boatImmatriculation = null;
        } else {
            this.boatImmatriculation = Integer.valueOf(boatImmatriculation);
        }
    }

    public void setBoatImmatriculation(Integer boatImmatriculation) {
        this.boatImmatriculation = boatImmatriculation;
    }

    public Integer getBoatImmatriculation() {
        return boatImmatriculation;
    }

    public String getShipOwnerName() {
        return shipOwnerName;
    }

    public void setShipOwnerName(String shipOwnerName) {
        this.shipOwnerName = shipOwnerName;
    }
}
