/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: AbstractFilteredPage.java 1082 2011-03-22 10:30:29Z sletellier $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.1.2/wao-ui/src/main/java/fr/ifremer/wao/ui/base/AbstractFilteredPage.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.FishingGearDCF;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.TargetSpeciesDCF;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.FiltersModel;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

import static fr.ifremer.wao.ui.data.TapestryUtil.getEntityFromModel;

/**
 * AbstractFilteredPage
 *
 * Created: 14 janv. 2010
 *
 * This class uses the BoatFilter bean (also SamplingFilter and UserFilter which
 * are supertypes).
 *
 * Known implementations are {@link fr.ifremer.wao.ui.pages.Synthesis }
 * and {@link fr.ifremer.wao.ui.pages.Contacts }
 *
 * You must override the three abstract methods and call {@link #initSelectFilters(boolean, boolean, boolean)} () }
 * in the setupRender of the page.
 * <pre>
 * - BoatName uses an Autocomplete mixins :
 *      <t:textfield t:id="boatName" t:value="filter.boatName" t:mixins="Autocomplete"/>
 * - SampleRow select value is sampleRowId :
 *      <input t:type="select" t:id="sampleRow" t:model="sampleRowSelectModel" value="sampleRowId" />
 * - Company select value is companyId :
 *      <input t:type="select" t:id="company" t:model="companySelectModel" value="companyId" />
 * - Observer select value is observerId :
 *      <input t:type="select" t:id="observer" t:model="observerSelectModel" value="observerId" />
 *
 * Use submit button with specific ids to refresh data depends on select change:
 * - id="refreshByCompany" : refresh facadeSelect, sectorSelect, sampleRowSelect 
 *   and observerSelect
 * - id="refreshByFacade" : refresh sectorSelect and sampleRowSelect
 * - id="refreshBySector" : refresh sampleRowSelect
 *
 * </pre>
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @deprecated since 1.5.1 : too difficult to adapt on each page, use {@link FiltersModel} instead
 */
@Deprecated
public abstract class AbstractFilteredPage {

    @Inject
    private Logger log;

    @SessionState
    private ConnectedUser user;

    @Inject
    private PropertyAccess propertyAccess;
    
    @Inject
    private ServiceReferential serviceReferential;

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceBoat serviceBoat;

    @Inject
    private ServiceUser serviceUser;

    @Persist
    private FilterManager filterManager;

    @Persist
    private boolean observerSelect;

    @Persist
    private boolean programSelect;
    /*
     * Generic select models
     */
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;

    @Persist
    private GenericSelectModel<TerrestrialLocation> terrestrialLocationSelectModel;

    @Persist
    private GenericSelectModel<Company> companySelectModel;

    @Persist
    private GenericSelectModel<WaoUser> observerSelectModel;

    @Persist
    private GenericSelectModel<FishingGearDCF> dcfGearSelectModel;

    @Persist
    private GenericSelectModel<TargetSpeciesDCF> dcfSpeciesSelectModel;

    /*
     * Select models
     */
    @Persist
    private SelectModel facadeSelectModel;

    @Persist
    private SelectModel sectorSelectModel;

    @Persist
    private SelectModel programSelectModel;

    /**
     * Id
     */
    @Persist
    private String companyId;

    @Persist
    private String observerId;

    @Persist
    private String fishingGearDCFId;

    @Persist
    private String targetSpeciesDCFId;

    @Persist
    private String terrestrialDistrictId;


    private boolean edited;

    @Persist
    private String sampleRowId;

    public boolean isObserverSelect() {
        return observerSelect;
    }

    public boolean isProgramSelect() {
        return programSelect;
    }

    public String getSampleRowId() {
        return sampleRowId;
    }

    public void setSampleRowId(String sampleRowId) {
        this.sampleRowId = sampleRowId;
        SampleRow sampleRow = getEntityFromModel(getSampleRowSelectModel(), sampleRowId);
        getFilter().setSampleRow(sampleRow);
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
        Company company = getEntityFromModel(getCompanySelectModel(), companyId);
        getFilter().setCompany(company);
    }

    public String getObserverId() {
        return observerId;
    }

    public void setObserverId(String observerId) {
        this.observerId = observerId;
        WaoUser observer = getEntityFromModel(getObserverSelectModel(), observerId);
        getFilter().setObserver(observer);
    }

    public String getFishingGearDCFId() {
        return fishingGearDCFId;
    }

    public void setFishingGearDCFId(String fishingGearDCFId) {
        this.fishingGearDCFId = fishingGearDCFId;
        FishingGearDCF fishingGearDCF = getEntityFromModel(getDcfGearSelectModel(), fishingGearDCFId);
        getFilter().setFishingGearDCF(fishingGearDCF);
    }

    public String getTargetSpeciesDCFId() {
        return targetSpeciesDCFId;
    }

    public void setTargetSpeciesDCFId(String targetSpeciesDCFId) {
        this.targetSpeciesDCFId = targetSpeciesDCFId;
        TargetSpeciesDCF targetSpeciesDCF = getEntityFromModel(getDcfSpeciesSelectModel(), targetSpeciesDCFId);
        getFilter().setTargetSpeciesDCF(targetSpeciesDCF);
    }

    public String getTerrestrialDistrictId() {
        return terrestrialDistrictId;
    }

    public void setTerrestrialDistrictId(String terrestrialDistrictId) {
        this.terrestrialDistrictId = terrestrialDistrictId;
        TerrestrialLocation terrestrialDistrict = getEntityFromModel(getTerrestrialDistrictSelectModel(), terrestrialDistrictId);
        getFilter().setTerrestrialDistrict(terrestrialDistrict);
    }

    public void onSelectedFromAddSampleRowCode() {
        if (getSampleRowId() != null) {

            List<SampleRow> rows = getFilter().getSampleRows();
            if (rows == null) {
                rows = new ArrayList<SampleRow>();
                getFilter().setSampleRows(rows);
            }
            SampleRow sampleRow = getSampleRowSelectModel().findObject(getSampleRowId());
            if ( ! rows.contains(sampleRow)) {
                rows.add(sampleRow);
            }
        }
    }

    public void onSelectedFromRemoveSampleRowCode() {
        if (getSampleRowId() != null) {
            getFilter().getSampleRows().remove(getSampleRowSelectModel().findObject(getSampleRowId()));
        }
    }

    /**
     * Need to be call in setupRender of the page which inherits this abstract
     * class.
     */
    public void initCompanyFilter()  {
        // Very very important to do that at beginning
        // Evo #2227 : Guest user has no default company filter
        if (user.isCoordinatorOrObserver()) {
            if (log.isDebugEnabled()) {
                log.debug("Company filtered : " + user.getCompany().getName());
            }
            getFilter().setCompany(user.getCompany());
        }
    }

    /**
     * Initialize all select for filters. By default, only facade, sector and
     * sampleRow selects will be initialized.
     *
     * @param companySelect if true, company select will be initialized
     * @param observerSelect if true, observer select will be initialized
     * @param programSelect
     * @throws WaoException
     */
    public void initSelectFilters(
            boolean companySelect,
            boolean observerSelect,
            boolean programSelect) throws WaoException {

        this.observerSelect = observerSelect;
        this.programSelect = programSelect;

        if (getFilter().getSampleRow() != null) {
            if (log.isDebugEnabled()) {
                log.debug("SampleRow filtered : " + getFilter().getSampleRow());
            }
            setSampleRowId(getFilter().getSampleRow().getTopiaId());
        }

        if (user.isAdmin() && companySelect) {
            resetCompanySelectModel();
            if (getFilter().getCompany() != null) {
                setCompanyId(getFilter().getCompany().getTopiaId());
            }
        }
//        else if (!user.isAdmin()) {
//            if (log.isDebugEnabled()) {
//                log.debug("Company filtered : " + user.getCompany());
//            }
//            getFilter().setCompany(user.getCompany());
//        }

        if (observerSelect) {
            resetObserverSelectModel();
            getObserverSelectModel();

            if (getFilter().getObserver() != null) {
                setObserverId(getFilter().getObserver().getTopiaId());
            }
        }

        if (programSelect) {
            resetProgramSelectModel();
            getProgramSelectModel();
        }

        resetFacadeSelectModel();
        resetSectorSelectModel();
        resetSampleRowSelectModel();

        initCompagnyFilter();
    }

    public void initCompagnyFilter() {
        // Very very important to do that at beginning
        // Evo #2227 : Guest user has no default company filter
        if (user.isCoordinatorOrObserver()) {
            if (log.isDebugEnabled()) {
                log.debug("Company filtered : " + user.getCompany().getName());
            }
            getFilter().setCompany(user.getCompany());
        }
    }

    public void resetCompanySelectModel() throws WaoException {
        companySelectModel = null;
        companyId = null;
    }

    public void resetSampleRowSelectModel() throws WaoException {
        sampleRowSelectModel = null;
        getFilter().setSampleRow(null);
    }

    public void resetObserverSelectModel() {
        observerSelectModel = null;
        observerId = null;
    }

    public void resetTerrestrialDistrictModel() {
        terrestrialLocationSelectModel = null;
        terrestrialDistrictId = null;
    }

    public void resetTargetSpeciesDCFModel() {
        dcfSpeciesSelectModel = null;
        targetSpeciesDCFId = null;
    }

    public void resetFishingGearDCFModel() {
        dcfGearSelectModel = null;
        fishingGearDCFId = null;
    }

    public void resetFacadeSelectModel() throws WaoException {
        facadeSelectModel = null;
    }

    public void resetSectorSelectModel() throws WaoException {
        sectorSelectModel = null;
    }

    public void resetProgramSelectModel() {
        programSelectModel = null;
    }

    public void resetModels() {
        resetCompanySelectModel();
        resetFacadeSelectModel();
        resetObserverSelectModel();
        resetProgramSelectModel();
        resetSampleRowSelectModel();
        resetSectorSelectModel();
        resetTerrestrialDistrictModel();
        resetTargetSpeciesDCFModel();
        resetFishingGearDCFModel();
    }

    /**
     * Get select model for sampleRows. Depends on filter (Sampling part only).
     * The sampleRow set from filter is temporarly extracted to avoid returning
     * only one element in the select.
     *
     * @return the GenericSelectModel<SampleRow> for sampleRows
     * @throws WaoException
     */
    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws WaoException {
        if (sampleRowSelectModel == null) {
            // WARN : no use of sampleRow filter

            List<SampleRow> rowsFiltered = getFilter().getSampleRows();
            getFilter().setSampleRows(null);
            List<SampleRow> sampleRows = serviceSampling.getSampleRowsByFilter(getFilter());
            getFilter().setSampleRows(rowsFiltered);

            sampleRowSelectModel = new GenericSelectModel<SampleRow>(sampleRows, SampleRow.class,
                SampleRow.PROPERTY_CODE, SampleRow.TOPIA_ID, propertyAccess);
        }
        return sampleRowSelectModel;
    }

    /**
     * Get select model for fishingZone facade. Depends on company set in
     * filter.
     *
     * @return the SelectModel for facade names
     * @throws WaoException
     */
    public SelectModel getFacadeSelectModel() throws WaoException {
        if (facadeSelectModel == null) {
            List<OptionModel> options;
            options = getOptionModels(serviceReferential.getFacades(getFilter()));
            facadeSelectModel = new SelectModelImpl(null, options);
        }
        return facadeSelectModel;
    }

    /**
     * Get select model for fishingZone sector. Depends on facadeName and
     * company set in filter.
     *
     * @return the SelectModel for sector names
     * @throws WaoException
     */
    public SelectModel getSectorSelectModel() throws WaoException {
        if (sectorSelectModel == null) {
            List<OptionModel> options;
            options = getOptionModels(serviceReferential.getSectors(getFilter()));
            sectorSelectModel = new SelectModelImpl(null, options);
        }
        return sectorSelectModel;
    }

    /**
     * Get select model for companies. Depends on
     * {@link #isAvailableDataForFiltersOnly()} () } to return only activated
     * companies. This select model is only used by admin users.
     *
     * @return the GenericSelectModel<Company> for companies
     * @throws WaoException
     */
    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (companySelectModel == null) {
            List<Company> companies;
            companies = serviceUser.getCompanies(isAvailableDataForFiltersOnly());
            companySelectModel = new GenericSelectModel<Company>(companies, Company.class,
                    Company.PROPERTY_NAME, Company.TOPIA_ID, propertyAccess);
        }
        return companySelectModel;
    }

    /**
     * Get the select model for observers. Depends on
     * {@link #isAvailableDataForFiltersOnly() } to return only activated
     * companies.
     *
     * @return the GenericSelectModel<WaoUser> for observers
     * @throws WaoException
     */
    public GenericSelectModel<WaoUser> getObserverSelectModel() throws WaoException {
        if (observerSelectModel == null) {

            List<WaoUser> observers;
            observers =
                serviceUser.getObservers(getFilter().getCompany(),
                        isAvailableDataForFiltersOnly());

            observerSelectModel = new GenericSelectModel<WaoUser>(observers, WaoUser.class,
                    "fullName", "topiaId", propertyAccess);
        }
        return observerSelectModel;
    }

    /**
     * Get select model for sampleRow program. Depends on company set in
     * filter.
     *
     * @return the SelectModel for program names
     * @throws WaoException
     */
    public SelectModel getProgramSelectModel() throws WaoException {
        if (programSelectModel == null) {
            List<OptionModel> options;
            options = getOptionModels(serviceSampling.getPrograms(getFilter().getCompany()));
            programSelectModel = new SelectModelImpl(null, options);
        }
        return programSelectModel;
    }

    public GenericSelectModel<FishingGearDCF> getDcfGearSelectModel() throws WaoException {
        if (dcfGearSelectModel == null) {
            // don't filter with already defined DCFs
            FishingGearDCF keptFishingGearDCF = getFilter().getFishingGearDCF();
            getFilter().setFishingGearDCF(null);
            List<FishingGearDCF> fishingGearDCFs;
            fishingGearDCFs = serviceSampling.getDCFGears(getFilter());
            getFilter().setFishingGearDCF(keptFishingGearDCF);

            dcfGearSelectModel = new GenericSelectModel<FishingGearDCF>(fishingGearDCFs, FishingGearDCF.class,
                    "fullDescription", FishingGearDCF.TOPIA_ID, propertyAccess);
        }
        return dcfGearSelectModel;
    }

    public GenericSelectModel<TargetSpeciesDCF> getDcfSpeciesSelectModel() throws WaoException {
        if (dcfSpeciesSelectModel == null) {
            // don't filter with already defined DCFs
            TargetSpeciesDCF keptTargetSpeciesDCF = getFilter().getTargetSpeciesDCF();
            getFilter().setTargetSpeciesDCF(null);
            List<TargetSpeciesDCF> targetSpeciesDCFs;
            targetSpeciesDCFs = serviceSampling.getDCFSpecies(getFilter());
            getFilter().setTargetSpeciesDCF(keptTargetSpeciesDCF);

            dcfSpeciesSelectModel = new GenericSelectModel<TargetSpeciesDCF>(targetSpeciesDCFs, TargetSpeciesDCF.class,
                    "fullDescription", TargetSpeciesDCF.TOPIA_ID, propertyAccess);
        }
        return dcfSpeciesSelectModel;
    }

    public GenericSelectModel<TerrestrialLocation> getTerrestrialDistrictSelectModel() throws WaoException {
        if (terrestrialLocationSelectModel == null) {
            List<TerrestrialLocation> districts;
            districts = serviceReferential.getAllTerrestrialDistricts(new SamplingFilterImpl());
            terrestrialLocationSelectModel = new GenericSelectModel<TerrestrialLocation>(districts, TerrestrialLocation.class,
                "description", SampleRow.TOPIA_ID, propertyAccess);
        }
        return terrestrialLocationSelectModel;
    }

    protected List<OptionModel> getOptionModels(List<String> names) {
        List<OptionModel> options = new ArrayList<OptionModel>();
        for (String name : names) {
            options.add(new OptionModelImpl(name, name));
        }
        return options;
    }

    protected abstract SamplingFilter getFilter() throws WaoException;

    /**
     * Used to show only active company and observers.
     *
     * @return true if only active users will be showed, false otherwise
     */
    protected abstract boolean isAvailableDataForFiltersOnly();

    protected abstract void resetFilter();

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        List<String> results = serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }


    /**
     * Called when search submit button is pressed. This method is useful to
     * refresh all filters data from selects.
     *
     * @throws WaoException
     */
    public void onSelectedFromSearch() throws WaoException {
        if (log.isDebugEnabled()) {
            log.debug("REFRESH FILTERS DATA");
            log.debug("observerSelect : " + isObserverSelect());
        }
        //SampleRow row = getSampleRowSelectModel().findObject(sampleRowId);
        // getFilter().setSampleRow(row);
        if (user.isAdmin()) {
            Company company = getCompanySelectModel().findObject(getCompanyId());
            getFilter().setCompany(company);
        } else {
            getFilter().setCompany(user.getCompany());
        }

        if (isObserverSelect()) {
            WaoUser observer = getObserverSelectModel().findObject(getObserverId());
            if (log.isDebugEnabled()) {
                log.debug("Observer selected : " +
                        (observer != null ? observer.getFullName() : "null"));
            }
            getFilter().setObserver(observer);
        }

        String fishingGearDCFId = getFishingGearDCFId();
        if (fishingGearDCFId != null) {
            FishingGearDCF fishingGearDCF = getDcfGearSelectModel().findObject(fishingGearDCFId);
            getFilter().setFishingGearDCF(fishingGearDCF);
        }
        String targetSpeciesDCFId = getTargetSpeciesDCFId();
        if (targetSpeciesDCFId != null) {
            TargetSpeciesDCF targetSpeciesDCF = getDcfSpeciesSelectModel().findObject(targetSpeciesDCFId);
            getFilter().setTargetSpeciesDCF(targetSpeciesDCF);
        }
        updateLocation(getTerrestrialDistrictId());
    }

    public void updateLocation(String terrestrialDistrictId) {
        if (log.isDebugEnabled()) {
            log.debug("in filters : terrestrialDistrictId = " + terrestrialDistrictId);
        }
        TerrestrialLocation district = getTerrestrialDistrictSelectModel().findObject(terrestrialDistrictId);
        getFilter().setTerrestrialDistrict(district);
    }

    /**
     * EVENT :: selected on refreshByCompany submit button. Reset selects for
     * company selected : programs, facades, sectors, sampleRows and observers.
     * This method set the state to edited, you can use
     * {@link AbstractFilteredPage#isEdited() } method to test it.
     *
     * @throws WaoException
     * @see AbstractFilteredPage#onSelectedFromRefreshByProgram()
     */
    public void onSelectedFromRefreshByCompany() throws WaoException {
        // Reset programs (the behavior is needed even if programSelect is false)
        getFilter().setProgramName(null);
        onSelectedFromRefreshByProgram();
        if (isObserverSelect()) {
            // Reset observers
            getFilter().setObserver(null);
            resetObserverSelectModel();
            getObserverSelectModel();
        }
        if (isProgramSelect()) {
            resetProgramSelectModel();
            getProgramSelectModel();
        }
        edited = true;
    }

    /**
     * EVENT :: selected on refreshByProgram submit button. Reset selects for
     * program selected : facades, sectors and sampleRows.
     * This method set the state to edited, you can use
     * {@link AbstractFilteredPage#isEdited() } method to test it.
     *
     * @throws WaoException
     * @see AbstractFilteredPage#onSelectedFromRefreshByFacade()
     */
    public void onSelectedFromRefreshByProgram() throws WaoException {
        // Reset facades
        getFilter().setFacadeName(null);
        onSelectedFromRefreshByFacade();
        resetFacadeSelectModel();
    }

    /**
     * EVENT :: selected on refreshByFacade submit button. Reset selects for
     * facade selected : sectors and sampleRows.
     * This method set the state to edited, you can use
     * {@link AbstractFilteredPage#isEdited() } method to test it.
     *
     * @throws WaoException
     * @see AbstractFilteredPage#onSelectedFromRefreshBySector()
     */
    public void onSelectedFromRefreshByFacade() throws WaoException {
        // Reset sectors
        getFilter().setSectorName(null);
        onSelectedFromRefreshBySector();
        resetSectorSelectModel();
    }

    /**
     * EVENT :: selected on refreshBySector submit button. After refreshing 
     * data selected, reset selects for sector selected : sampleRows.
     * This method set the state to edited, you can use
     * {@link AbstractFilteredPage#isEdited() } method to test it.
     *
     * @throws WaoException
     * @see AbstractFilteredPage#onSelectedFromSearch()
     */
    public void onSelectedFromRefreshBySector() throws WaoException {
        // Update selected data
        onSelectedFromSearch();
        // Reset sampleRows;
        getFilter().setSampleRow(null);
        resetSampleRowSelectModel();
        edited = true;
    }

    /**
     * Used to indicate that a refresh as been triggered.
     *
     * @return true if the page filter is in edited state.
     */
    protected boolean isEdited() {
        return edited;
    }

}
