/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Node;
import winstone.Launcher;
import winstone.Logger;
import winstone.RequestDispatcher;
import winstone.WebAppConfiguration;

public class ServletConfiguration
implements ServletConfig,
Comparable {
    static final String ELEM_NAME = "servlet-name";
    static final String ELEM_DISPLAY_NAME = "display-name";
    static final String ELEM_CLASS = "servlet-class";
    static final String ELEM_JSP_FILE = "jsp-file";
    static final String ELEM_DESCRIPTION = "description";
    static final String ELEM_INIT_PARAM = "init-param";
    static final String ELEM_INIT_PARAM_NAME = "param-name";
    static final String ELEM_INIT_PARAM_VALUE = "param-value";
    static final String ELEM_LOAD_ON_STARTUP = "load-on-startup";
    static final String ELEM_RUN_AS = "run-as";
    static final String ELEM_SECURITY_ROLE_REF = "security-role-ref";
    static final String ELEM_ROLE_NAME = "role-name";
    static final String ELEM_ROLE_LINK = "role-link";
    final String JSP_FILE = "org.apache.catalina.jsp_file";
    private String servletName;
    private String classFile;
    private Servlet instance;
    private Map initParameters;
    private WebAppConfiguration webAppConfig;
    private int loadOnStartup;
    private String jspFile;
    private Map securityRoleRefs;
    private Object servletSemaphore = new Boolean(true);
    private boolean isSingleThreadModel = false;
    private boolean unavailable = false;
    private Throwable unavailableException = null;

    protected ServletConfiguration(WebAppConfiguration webAppConfig) {
        this.webAppConfig = webAppConfig;
        this.initParameters = new Hashtable();
        this.loadOnStartup = -1;
        this.securityRoleRefs = new Hashtable();
    }

    public ServletConfiguration(WebAppConfiguration webAppConfig, String servletName, String className, Map initParams, int loadOnStartup) {
        this(webAppConfig);
        if (initParams != null) {
            this.initParameters.putAll(initParams);
        }
        this.servletName = servletName;
        this.classFile = className;
        this.jspFile = null;
        this.loadOnStartup = loadOnStartup;
    }

    public ServletConfiguration(WebAppConfiguration webAppConfig, Node elm) {
        this(webAppConfig);
        for (int n = 0; n < elm.getChildNodes().getLength(); ++n) {
            int k;
            Node child = elm.getChildNodes().item(n);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            if (nodeName.equals(ELEM_NAME)) {
                this.servletName = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (nodeName.equals(ELEM_CLASS)) {
                this.classFile = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (nodeName.equals(ELEM_JSP_FILE)) {
                this.jspFile = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (nodeName.equals(ELEM_LOAD_ON_STARTUP)) {
                String index = child.getFirstChild() == null ? "-1" : WebAppConfiguration.getTextFromNode(child);
                this.loadOnStartup = Integer.parseInt(index);
                continue;
            }
            if (nodeName.equals(ELEM_INIT_PARAM)) {
                String paramName = "";
                String paramValue = "";
                for (k = 0; k < child.getChildNodes().getLength(); ++k) {
                    Node paramNode = child.getChildNodes().item(k);
                    if (paramNode.getNodeType() != 1) continue;
                    if (paramNode.getNodeName().equals(ELEM_INIT_PARAM_NAME)) {
                        paramName = WebAppConfiguration.getTextFromNode(paramNode);
                        continue;
                    }
                    if (!paramNode.getNodeName().equals(ELEM_INIT_PARAM_VALUE)) continue;
                    paramValue = WebAppConfiguration.getTextFromNode(paramNode);
                }
                if (paramName.equals("")) continue;
                this.initParameters.put(paramName, paramValue);
                continue;
            }
            if (nodeName.equals(ELEM_RUN_AS)) {
                for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                    Node roleElm = child.getChildNodes().item(m);
                    if (roleElm.getNodeType() == 1 && !roleElm.getNodeName().equals(ELEM_ROLE_NAME)) continue;
                }
                continue;
            }
            if (!nodeName.equals(ELEM_SECURITY_ROLE_REF)) continue;
            String name = "";
            String link = "";
            for (k = 0; k < child.getChildNodes().getLength(); ++k) {
                Node roleRefNode = child.getChildNodes().item(k);
                if (roleRefNode.getNodeType() != 1) continue;
                if (roleRefNode.getNodeName().equals(ELEM_ROLE_NAME)) {
                    name = WebAppConfiguration.getTextFromNode(roleRefNode);
                    continue;
                }
                if (!roleRefNode.getNodeName().equals(ELEM_ROLE_LINK)) continue;
                link = WebAppConfiguration.getTextFromNode(roleRefNode);
            }
            if (name.equals("") || link.equals("")) continue;
            this.initParameters.put(name, link);
        }
        if (this.jspFile != null && this.classFile == null) {
            this.classFile = "org.apache.jasper.servlet.JspServlet";
            WebAppConfiguration.addJspServletParams(this.initParameters);
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ServletConfiguration.DeployedInstance", new String[]{this.servletName, this.classFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialization() {
        if (this.instance != null) {
            return;
        }
        Object object = this.servletSemaphore;
        synchronized (object) {
            if (this.instance != null) {
                return;
            }
            if (this.unavailableException != null) {
                return;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            Servlet newInstance = null;
            Throwable otherError = null;
            try {
                Class<?> servletClass = Class.forName(this.classFile, true, this.webAppConfig.getLoader());
                newInstance = (Servlet)servletClass.newInstance();
                this.isSingleThreadModel = Class.forName("javax.servlet.SingleThreadModel").isInstance(newInstance);
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "ServletConfiguration.init", this.servletName);
                newInstance.init(this);
                this.instance = newInstance;
            }
            catch (ClassNotFoundException err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ServletConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                this.setUnavailable(newInstance);
                this.unavailableException = err;
            }
            catch (IllegalAccessException err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ServletConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                this.setUnavailable(newInstance);
                this.unavailableException = err;
            }
            catch (InstantiationException err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ServletConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                this.setUnavailable(newInstance);
                this.unavailableException = err;
            }
            catch (ServletException err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ServletConfiguration.InitError", this.servletName, (Throwable)err);
                this.instance = null;
                this.setUnavailable(newInstance);
                this.unavailableException = err;
            }
            catch (RuntimeException err) {
                otherError = err;
                throw err;
            }
            catch (Error err) {
                otherError = err;
                throw err;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
                if (otherError == null && this.unavailableException == null) {
                    this.instance = newInstance;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ServletRequest request, ServletResponse response, String requestURI) throws ServletException, IOException {
        block11: {
            this.ensureInitialization();
            if (this.unavailable) {
                RequestDispatcher rd = this.webAppConfig.getErrorDispatcherByClass(this.unavailableException);
                rd.forward(request, response);
                return;
            }
            if (this.jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", this.jspFile);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            try {
                if (this.isSingleThreadModel) {
                    ServletConfiguration servletConfiguration = this;
                    synchronized (servletConfiguration) {
                        this.instance.service(request, response);
                        break block11;
                    }
                }
                this.instance.service(request, response);
            }
            catch (UnavailableException err) {
                this.setUnavailable(this.instance);
                ((HttpServletResponse)response).sendError(404, Launcher.RESOURCES.getString("StaticResourceServlet.PathNotFound", requestURI));
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public ServletContext getServletContext() {
        return this.webAppConfig;
    }

    public String getServletName() {
        return this.servletName;
    }

    public Map getSecurityRoleRefs() {
        return this.securityRoleRefs;
    }

    public int compareTo(Object objTwo) {
        Integer one = new Integer(this.loadOnStartup);
        Integer two = new Integer(((ServletConfiguration)objTwo).loadOnStartup);
        return one.compareTo(two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.servletSemaphore;
        synchronized (object) {
            this.setUnavailable(this.instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUnavailable(Servlet unavailableServlet) {
        this.unavailable = true;
        if (unavailableServlet != null) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "ServletConfiguration.destroy", this.servletName);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            try {
                unavailableServlet.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
                this.instance = null;
            }
        }
        this.webAppConfig.removeServletConfigurationAndMappings(this);
    }
}

