/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.w3c.dom.Node;
import winstone.Launcher;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;

public class FilterConfiguration
implements FilterConfig {
    final String ELEM_NAME = "filter-name";
    final String ELEM_DISPLAY_NAME = "display-name";
    final String ELEM_CLASS = "filter-class";
    final String ELEM_DESCRIPTION = "description";
    final String ELEM_INIT_PARAM = "init-param";
    final String ELEM_INIT_PARAM_NAME = "param-name";
    final String ELEM_INIT_PARAM_VALUE = "param-value";
    private String filterName;
    private String classFile;
    private Filter instance;
    private Map initParameters;
    private ServletContext context;
    private ClassLoader loader;
    private boolean unavailableException;
    private Object filterSemaphore = new Boolean(true);

    protected FilterConfiguration(ServletContext context, ClassLoader loader) {
        this.context = context;
        this.loader = loader;
        this.initParameters = new Hashtable();
    }

    public FilterConfiguration(ServletContext context, ClassLoader loader, Node elm) {
        this(context, loader);
        for (int n = 0; n < elm.getChildNodes().getLength(); ++n) {
            Node child = elm.getChildNodes().item(n);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            if (nodeName.equals("filter-name")) {
                this.filterName = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (nodeName.equals("filter-class")) {
                this.classFile = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (!nodeName.equals("init-param")) continue;
            String paramName = null;
            String paramValue = null;
            for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                Node paramNode = child.getChildNodes().item(k);
                if (paramNode.getNodeType() != 1) continue;
                if (paramNode.getNodeName().equals("param-name")) {
                    paramName = WebAppConfiguration.getTextFromNode(paramNode);
                    continue;
                }
                if (!paramNode.getNodeName().equals("param-value")) continue;
                paramValue = WebAppConfiguration.getTextFromNode(paramNode);
            }
            if (paramName == null || paramValue == null) continue;
            this.initParameters.put(paramName, paramValue);
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "FilterConfiguration.DeployedInstance", new String[]{this.filterName, this.classFile});
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getInitParameter(String paramName) {
        return (String)this.initParameters.get(paramName);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() throws ServletException {
        Object object = this.filterSemaphore;
        synchronized (object) {
            if (this.isUnavailable()) {
                throw new WinstoneException(Launcher.RESOURCES.getString("FilterConfiguration.FilterUnavailable"));
            }
            if (this.instance == null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.loader);
                    Class<?> filterClass = Class.forName(this.classFile, true, this.loader);
                    this.instance = (Filter)filterClass.newInstance();
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "FilterConfiguration.init", this.filterName);
                    this.instance.init(this);
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (ClassNotFoundException err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "FilterConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                }
                catch (IllegalAccessException err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "FilterConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                }
                catch (InstantiationException err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "FilterConfiguration.ClassLoadError", this.classFile, (Throwable)err);
                }
                catch (ServletException err) {
                    this.instance = null;
                    if (err instanceof UnavailableException) {
                        this.setUnavailable();
                    }
                    throw err;
                }
            }
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.filterSemaphore;
        synchronized (object) {
            this.setUnavailable();
        }
    }

    public String toString() {
        return Launcher.RESOURCES.getString("FilterConfiguration.Description", new String[]{this.filterName, this.classFile});
    }

    public boolean isUnavailable() {
        return this.unavailableException;
    }

    protected void setUnavailable() {
        this.unavailableException = true;
        if (this.instance != null) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "FilterConfiguration.destroy", this.filterName);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            this.instance.destroy();
            Thread.currentThread().setContextClassLoader(cl);
            this.instance = null;
        }
    }

    public void execute(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.getFilter().doFilter(request, response, chain);
        }
        catch (UnavailableException err) {
            this.setUnavailable();
            throw new ServletException(Launcher.RESOURCES.getString("RequestDispatcher.FilterError"), err);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

