/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.ui.components.ImportFieldSet;

import java.io.InputStream;

/**
 * This interface is used for {@link ImportFieldSet} component to execute an import.
 * The page need to implement the {@link #execute(InputStream)} method to use
 * the component.
 *
 * Created: 18 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: ImportEngine.java 590 2010-07-06 14:09:45Z fdesbois $
 */
public interface ImportEngine {

    /**
     * Excute an import from an {@code input} stream. This method was called
     * in {@link ImportFieldSet} when file are successfully uploaded. This method
     * to to return an {@link ImportResults} that contains stats and errors
     * from import.
     *
     * @param input InputStream of the file to import
     * @return an ImportResults that contains statistics and errors from import
     * @throws WaoException for unknown errors
     * @throws WaoBusinessException for known errors
     */
    ImportResults execute(InputStream input) throws WaoException, WaoBusinessException;
}
