/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.services.Response;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created: 18 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id$
 */
public class LogFile {

    @Parameter(required = true)
    @Property
    private InputStream source;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String title;

    @Parameter(defaultPrefix = BindingConstants.ASSET)
    @Property
    private Asset icon;

    public StreamResponse onActionFromShowLogFile() {
        return new StreamResponse() {

            @Override
            public String getContentType() {
                return "text/plain;charset=utf-8";
            }

            @Override
            public InputStream getStream() throws IOException {
                return source;
            }

            @Override
            public void prepareResponse(Response response) {
            }
        };
    }
}
