/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.ActivityCalendar;
import fr.ifremer.wao.entity.ActivityMonth;
import fr.ifremer.wao.entity.ActivityProfession;
import fr.ifremer.wao.entity.ActivityZone;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@IncludeStylesheet(value={"context:css/boats.css"})
public class BoatActivityCalendar {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @Inject
    private ServiceBoat serviceBoat;
    @SessionState
    private ConnectedUser user;
    private ActivityCalendar activityCalendar;
    @Property
    private int month;
    @Property
    private int professionIndex;
    @Property
    private int zoneIndex;
    private Boat boat;
    private Integer boatImmatriculation;

    void setupRender() {
        if (this.boatImmatriculation == null) {
            this.layout.addFatal("Page inaccessible, aucun navire charg\u00e9 permettant l'affichage du calendrier d'activit\u00e9. Veuillez retourner sur la page des navires.");
        } else {
            try {
                this.getBoat();
            }
            catch (WaoBusinessException eee) {
                this.layout.addFatal(eee.getMessage());
            }
        }
    }

    void onActivate(Integer boatImmatriculation) {
        this.boatImmatriculation = boatImmatriculation;
    }

    Integer onPassivate() {
        return this.boatImmatriculation;
    }

    @Deprecated
    public void setBoat(Boat boat) {
        this.boat = boat;
    }

    public Boat getBoat() throws WaoBusinessException {
        if (this.boat == null) {
            this.boat = this.serviceBoat.getBoat(this.boatImmatriculation);
        }
        return this.boat;
    }

    public List<Boat> getBoats() {
        return Collections.singletonList(this.boat);
    }

    public ActivityCalendar getActivityCalendar() throws WaoBusinessException {
        if (this.activityCalendar == null) {
            this.activityCalendar = this.serviceBoat.getLastActivityCalendar(this.user, this.getBoat());
        }
        return this.activityCalendar;
    }

    public ActivityMonth getActivityMonth() throws WaoBusinessException {
        return this.getActivityCalendar().getActivityMonth(this.month);
    }

    public String getMonthName() {
        String libelle = DateUtils.getMonthLibelle((int)this.month);
        return StringUtils.capitalize((String)libelle);
    }

    public int getProfessionIndexMax() {
        int result = 0;
        for (ActivityMonth curr : this.activityCalendar.getActivityMonth()) {
            int nbProfessions = curr.sizeActivityProfession();
            if (nbProfessions <= result) continue;
            result = nbProfessions;
        }
        return result - 1;
    }

    public boolean hasProfessions() {
        return this.getProfessionIndexMax() != -1;
    }

    public ActivityProfession getActivityProfession() throws WaoBusinessException {
        if (this.getActivityMonth() == null) {
            return null;
        }
        if (this.professionIndex >= this.getActivityMonth().sizeActivityProfession()) {
            return null;
        }
        return (ActivityProfession)this.getActivityMonth().getActivityProfession().get(this.professionIndex);
    }

    public int getZoneIndexMax() throws WaoBusinessException {
        int result = 0;
        for (ActivityMonth activityMonth : this.activityCalendar.getActivityMonth()) {
            int nbZones;
            this.month = activityMonth.getMonth();
            ActivityProfession profession = this.getActivityProfession();
            if (profession == null || (nbZones = profession.sizeActivityZone()) <= result) continue;
            result = nbZones;
        }
        return result - 1;
    }

    public String getNorow() {
        return null;
    }

    public ActivityZone getActivityZone() throws WaoBusinessException {
        ActivityProfession profession = this.getActivityProfession();
        if (profession == null) {
            return null;
        }
        if (this.zoneIndex >= profession.sizeActivityZone()) {
            return null;
        }
        return (ActivityZone)profession.getActivityZone().get(this.zoneIndex);
    }

    public Object[] getBoatsPageContext() throws WaoBusinessException {
        return new Object[]{null, this.getBoat().getImmatriculation()};
    }
}

