/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.entity.WaoUserImpl;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import org.apache.tapestry5.services.ApplicationStateManager;

public class ServiceAuthenticationImpl
implements ServiceAuthentication {
    private final ApplicationStateManager stateManager;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public boolean isUserConnected() {
        return this.stateManager.exists(WaoUser.class);
    }

    public WaoUser getUserConnected() {
        return (WaoUser)this.stateManager.getIfExists(WaoUser.class);
    }

    public void setUserConnected(WaoUser user) {
        this.stateManager.set(WaoUser.class, (Object)user);
    }

    public boolean isAllowed(Class<?> page) {
        if (page.isAnnotationPresent(RequiresAuthentication.class) && this.isUserConnected()) {
            RequiresAuthentication check = page.getAnnotation(RequiresAuthentication.class);
            WaoUser user = this.getUserConnected();
            if (user.getReadOnly() && !check.readOnlyAllowed()) {
                return false;
            }
            for (UserRole role : check.value()) {
                if (!role.equals((Object)user.getUserRole())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public WaoUser getNewUserInstance() {
        return new WaoUserImpl();
    }
}

