/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

/**
 * ExceptionReport
 *
 * Created: 5 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 355 $
 *
 * Mise a jour: $Date: 2010-02-16 14:56:07 +0100 (mar., 16 févr. 2010) $
 * par : $Author$
 */
public class ExceptionReport implements ExceptionReporter, WaoPage {

    @InjectComponent
    private Layout layout;

    @Inject
    private Logger log;

    @Property
    private Throwable exception;

    @Override
    public void reportException(Throwable eee) {
        this.exception = getWaoException(eee);
        if (exception != null) {
            layout.getFeedBack().addError(exception.getMessage());
            this.exception = exception.getCause();
        } else {
            this.exception = eee;
            log.error("Unexpected exception", eee);
        }
        layout.getFeedBack().addError("Erreur : " + this.exception.getClass().getSimpleName() + " : " + this.exception.getMessage());
    }

    protected Throwable getWaoException(Throwable eee) {
        if (eee == null) {
            return eee;
        }
        if (eee instanceof WaoException) {
            return eee;
        }
        return getWaoException(eee.getCause());
    }

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }
        
}
