/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JList;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import org.apache.commons.lang3.mutable.MutableInt;

public class CaracteristicsCount {
    private final MutableInt ZERO = new MutableInt();
    private final Map<Integer, MutableInt> counts = new TreeMap<Integer, MutableInt>();

    public void attachPredicateToUi(BeanDoubleList<Caracteristic> ui) {
        Predicate listPredicate = input -> {
            JList selectedList = ui.getSelectedList();
            List selectedValuesList = selectedList.getSelectedValuesList();
            for (Caracteristic caracteristic : selectedValuesList) {
                if (!this.isCaracteristicUsed(caracteristic)) continue;
                return false;
            }
            return true;
        };
        ui.getModel().addCanRemoveItemsPredicate(listPredicate);
    }

    public boolean isCaracteristicUsed(Caracteristic caracteristic) {
        Objects.requireNonNull(caracteristic);
        MutableInt result = this.counts.getOrDefault(caracteristic.getIdAsInt(), this.ZERO);
        return result.intValue() > 0;
    }

    public void addCaracteristic(Caracteristic caracteristic) {
        Objects.requireNonNull(caracteristic);
        this.counts.compute(caracteristic.getIdAsInt(), (k, v) -> {
            if (v == null) {
                return new MutableInt(1);
            }
            v.increment();
            return v;
        });
    }

    public void removeCaracteristic(Caracteristic caracteristic) {
        Objects.requireNonNull(caracteristic);
        this.counts.compute(caracteristic.getIdAsInt(), (k, v) -> {
            if (v == null || v.intValue() == 1) {
                return null;
            }
            v.decrement();
            return v;
        });
    }

    public void removeCaracteristics(Collection<Caracteristic> caracteristics) {
        Objects.requireNonNull(caracteristics);
        caracteristics.forEach(this::removeCaracteristic);
    }
}

