/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ProgramSelectTreeNode;
import java.io.File;
import java.util.Collections;
import org.jdesktop.beans.AbstractSerializableBean;

public class GenericFormatImportUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PROGRAM = "program";
    public static final String PROPERTY_IMPORT_FILE = "importFile";
    public static final String PROPERTY_CLEAN_WEIGHTS = "cleanWeights";
    public static final String PROPERTY_CHECK_WEIGHTS = "checkWeights";
    public static final String PROPERTY_IMPORT_ATTACHMENTS = "importAttachments";
    public static final String PROPERTY_IMPORT_SPECIES = "importSpecies";
    public static final String PROPERTY_IMPORT_BENTHOS = "importBenthos";
    public static final String PROPERTY_IMPORT_MARINE_LITTER = "importMarineLitter";
    public static final String PROPERTY_IMPORT_ACCIDENTAL_CATCH = "importAccidentalCatch";
    public static final String PROPERTY_IMPORT_INDIVIDUAL_OBSERVATION = "importIndividualObservation";
    public static final String PROPERTY_UPDATE_CRUISES = "updateCruises";
    public static final String PROPERTY_UPDATE_OPERATIONS = "updateOperations";
    public static final String PROPERTY_CAN_VALIDATE = "canValidate";
    public static final String PROPERTY_VALIDATE_RESULT = "validateResult";
    public static final String PROPERTY_VALIDATE_VALID = "validateValid";
    public static final String PROPERTY_VALIDATE_DONE = "validateDone";
    public static final String PROPERTY_CAN_IMPORT = "canImport";
    public static final String PROPERTY_IMPORT_RESULT = "importResult";
    public static final String PROPERTY_IMPORT_DONE = "importDone";
    public static final String PROPERTY_IMPORT_VALID = "importValid";
    public static final String PROPERTY_DATA_SELECTED = "dataSelected";
    public static final String PROPERTY_AUTHORIZE_OBSOLETE_REFERENTIALS = "authorizeObsoleteReferentials";
    private Program program;
    private File importFile;
    private boolean updateCruises = true;
    private boolean updateOperations = true;
    private boolean importSpecies = true;
    private boolean importBenthos = true;
    private boolean importMarineLitter = true;
    private boolean importAccidentalCatch = true;
    private boolean importIndividualObservation = true;
    private boolean importAttachments = true;
    private boolean cleanWeights;
    private boolean checkWeights;
    private boolean canValidate;
    private boolean authorizeObsoleteReferentials;
    private File validateReportFile;
    private GenericFormatValidateFileResult validateResult;
    private boolean canImport;
    private File importReportFile;
    private GenericFormatImportResult importResult;
    private ProgramSelectTreeNode rootNode;
    private boolean dataSelected;

    public GenericFormatImportConfiguration toValidateImportFileConfiguration(int maximumRowsInErrorsPerFile) {
        GenericFormatImportConfiguration configuration = new GenericFormatImportConfiguration();
        ProgramDataModel selectedDataModel = new ProgramDataModel(this.program, Collections.emptySet());
        configuration.setDataToExport(selectedDataModel);
        configuration.setMaximumRowsInErrorPerFile(maximumRowsInErrorsPerFile);
        configuration.setImportSpecies(this.importSpecies);
        configuration.setImportBenthos(this.importBenthos);
        configuration.setImportMarineLitter(this.importMarineLitter);
        configuration.setImportAccidentalCatch(this.importAccidentalCatch);
        configuration.setImportIndividualObservation(this.importIndividualObservation);
        configuration.setImportAttachments(this.importAttachments);
        configuration.setAuthorizeObsoleteReferentials(this.authorizeObsoleteReferentials);
        configuration.setCleanWeights(this.cleanWeights);
        configuration.setCheckWeights(this.checkWeights);
        configuration.setImportFile(this.importFile);
        configuration.setReportFile(this.validateReportFile);
        return configuration;
    }

    public GenericFormatImportConfiguration toImportConfiguration() {
        GenericFormatImportConfiguration configuration = new GenericFormatImportConfiguration();
        ProgramDataModel selectedDataModel = this.rootNode.getSelectedDataModel();
        configuration.setDataToExport(selectedDataModel);
        configuration.setUpdateCruises(this.updateCruises);
        configuration.setUpdateOperations(this.updateOperations);
        configuration.setImportSpecies(this.importSpecies);
        configuration.setImportBenthos(this.importBenthos);
        configuration.setImportMarineLitter(this.importMarineLitter);
        configuration.setImportAccidentalCatch(this.importAccidentalCatch);
        configuration.setImportIndividualObservation(this.importIndividualObservation);
        configuration.setImportAttachments(this.importAttachments);
        configuration.setAuthorizeObsoleteReferentials(this.authorizeObsoleteReferentials);
        configuration.setCleanWeights(this.cleanWeights);
        configuration.setCheckWeights(this.checkWeights);
        configuration.setImportFile(this.importFile);
        configuration.setReportFile(this.importReportFile);
        return configuration;
    }

    public boolean isSelectedDataExists(boolean isUpdateCruises) {
        return this.rootNode.isSelectedDataExists(isUpdateCruises);
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        Program oldValue = this.getProgram();
        this.program = program;
        this.firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        File oldValue = this.getImportFile();
        this.importFile = importFile;
        this.firePropertyChange(PROPERTY_IMPORT_FILE, oldValue, importFile);
        this.firePropertyChange(PROPERTY_VALIDATE_VALID, null, this.isValidateValid());
    }

    public boolean isCleanWeights() {
        return this.cleanWeights;
    }

    public void setCleanWeights(boolean cleanWeights) {
        this.cleanWeights = cleanWeights;
        this.firePropertyChange(PROPERTY_CLEAN_WEIGHTS, null, cleanWeights);
    }

    public boolean isCheckWeights() {
        return this.checkWeights;
    }

    public void setCheckWeights(boolean checkWeights) {
        this.checkWeights = checkWeights;
        this.firePropertyChange(PROPERTY_CHECK_WEIGHTS, null, checkWeights);
    }

    public boolean isUpdateCruises() {
        return this.updateCruises;
    }

    public void setUpdateCruises(boolean updateCruises) {
        this.updateCruises = updateCruises;
        this.firePropertyChange(PROPERTY_UPDATE_CRUISES, null, updateCruises);
    }

    public boolean isUpdateOperations() {
        return this.updateOperations;
    }

    public void setUpdateOperations(boolean updateOperations) {
        this.updateOperations = updateOperations;
        this.firePropertyChange(PROPERTY_UPDATE_OPERATIONS, null, updateOperations);
    }

    public boolean isImportSpecies() {
        return this.importSpecies;
    }

    public void setImportSpecies(boolean importSpecies) {
        this.importSpecies = importSpecies;
        this.firePropertyChange(PROPERTY_IMPORT_SPECIES, null, importSpecies);
    }

    public boolean isImportBenthos() {
        return this.importBenthos;
    }

    public void setImportBenthos(boolean importBenthos) {
        this.importBenthos = importBenthos;
        this.firePropertyChange(PROPERTY_IMPORT_BENTHOS, null, importBenthos);
    }

    public boolean isImportMarineLitter() {
        return this.importMarineLitter;
    }

    public void setImportMarineLitter(boolean importMarineLitter) {
        this.importMarineLitter = importMarineLitter;
        this.firePropertyChange(PROPERTY_IMPORT_MARINE_LITTER, null, importMarineLitter);
    }

    public boolean isImportAccidentalCatch() {
        return this.importAccidentalCatch;
    }

    public void setImportAccidentalCatch(boolean importAccidentalCatch) {
        this.importAccidentalCatch = importAccidentalCatch;
        this.firePropertyChange(PROPERTY_IMPORT_ACCIDENTAL_CATCH, null, importAccidentalCatch);
    }

    public boolean isImportIndividualObservation() {
        return this.importIndividualObservation;
    }

    public void setImportIndividualObservation(boolean importIndividualObservation) {
        this.importIndividualObservation = importIndividualObservation;
        this.firePropertyChange(PROPERTY_IMPORT_INDIVIDUAL_OBSERVATION, null, importIndividualObservation);
    }

    public boolean isImportAttachments() {
        return this.importAttachments;
    }

    public void setImportAttachments(boolean importAttachments) {
        this.importAttachments = importAttachments;
        this.firePropertyChange(PROPERTY_IMPORT_ATTACHMENTS, null, importAttachments);
    }

    public File getValidateReportFile() {
        return this.validateReportFile;
    }

    public void setValidateReportFile(File validateReportFile) {
        this.validateReportFile = validateReportFile;
    }

    public boolean isCanValidate() {
        return this.canValidate;
    }

    public void setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
        this.firePropertyChange(PROPERTY_CAN_VALIDATE, null, canValidate);
    }

    public GenericFormatValidateFileResult getValidateResult() {
        return this.validateResult;
    }

    public void setValidateResult(GenericFormatValidateFileResult validateResult) {
        this.validateResult = validateResult;
        this.firePropertyChange(PROPERTY_VALIDATE_RESULT, null, validateResult);
        this.firePropertyChange(PROPERTY_VALIDATE_DONE, null, this.isValidateDone());
        this.firePropertyChange(PROPERTY_VALIDATE_VALID, null, this.isValidateValid());
    }

    public boolean isValidateDone() {
        return this.validateResult != null;
    }

    public boolean isValidateValid() {
        return this.validateResult != null && this.validateResult.isValid();
    }

    public boolean isCanImport() {
        return this.canImport;
    }

    public void setCanImport(boolean canImport) {
        this.canImport = canImport;
        this.firePropertyChange(PROPERTY_CAN_IMPORT, null, canImport);
    }

    public File getImportReportFile() {
        return this.importReportFile;
    }

    public void setImportReportFile(File importReportFile) {
        this.importReportFile = importReportFile;
    }

    public GenericFormatImportResult getImportResult() {
        return this.importResult;
    }

    public void setImportResult(GenericFormatImportResult importResult) {
        this.importResult = importResult;
        this.firePropertyChange(PROPERTY_IMPORT_RESULT, null, importResult);
        this.firePropertyChange(PROPERTY_IMPORT_DONE, null, this.isImportDone());
        this.firePropertyChange(PROPERTY_IMPORT_VALID, null, this.isImportValid());
    }

    public boolean isDataSelected() {
        return this.dataSelected;
    }

    public void setDataSelected(boolean dataSelected) {
        this.dataSelected = dataSelected;
        this.firePropertyChange(PROPERTY_DATA_SELECTED, null, dataSelected);
    }

    public boolean isAuthorizeObsoleteReferentials() {
        return this.authorizeObsoleteReferentials;
    }

    public void setAuthorizeObsoleteReferentials(boolean authorizeObsoleteReferentials) {
        Boolean oldValue = this.isAuthorizeObsoleteReferentials();
        this.authorizeObsoleteReferentials = authorizeObsoleteReferentials;
        this.firePropertyChange(PROPERTY_AUTHORIZE_OBSOLETE_REFERENTIALS, oldValue, authorizeObsoleteReferentials);
    }

    public boolean isImportDone() {
        return this.importResult != null;
    }

    public boolean isImportValid() {
        return this.importResult != null && this.importResult.isValid();
    }

    public boolean computeIsCanValidate() {
        return this.program != null && this.importFile != null && this.importFile.exists();
    }

    public boolean computeIsCanImport() {
        return this.isValidateDone() && this.isValidateValid() && this.isDataSelected() && this.importResult == null;
    }

    public void setRootNode(ProgramSelectTreeNode rootNode) {
        this.rootNode = rootNode;
    }
}

