/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForOperation;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateOperationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateOperationAction.class);

    public ValidateOperationAction(GenericFormatContextSupport importContext) {
        super(importContext);
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate operation.csv file.");
        }
        boolean importSpecies = this.importContext.getImportRequest().isImportSpecies();
        boolean importBenthos = this.importContext.getImportRequest().isImportBenthos();
        boolean importMarineLitter = this.importContext.getImportRequest().isImportMarineLitter();
        int maximumRowsInErrorPerFile = this.importContext.getImportRequest().getMaximumRowsInErrorPerFile();
        GenericFormatCsvFileResult importFileResult = this.importContext.getOperationFileResult();
        try (CsvConsumerForOperation consumer = this.importContext.loadOperations(false);){
            for (ImportRow row : consumer) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.validate.operations", (Object[])new Object[]{row.getLineNumber()}));
                GenericFormatImportCruiseContext cruiseContext = consumer.validateRow(row, this.importContext);
                if (cruiseContext != null) {
                    consumer.prepareRowForPersist(row, importSpecies, importBenthos, importMarineLitter);
                    OperationRow bean = (OperationRow)row.getBean();
                    FishingOperation fishingOperation = bean.getFishingOperation();
                    CatchBatch catchBatch = bean.getCatchBatch();
                    this.importContext.addImportedFishingOperation(fishingOperation, catchBatch);
                }
                if (consumer.getNbRowsInErrors() <= maximumRowsInErrorPerFile) continue;
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"Too much errors, stop validating this file.");
                break;
            }
            this.flushConsumer(consumer, importFileResult);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close operation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

