/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForAccidentalCatch;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportAccidentalCatchAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportAccidentalCatchAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportAccidentalCatchAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid() && this.importContext.getImportRequest().isImportAccidentalCatch();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.accidentalCatches", (Object[])new Object[0]));
        if (!this.importContext.getImportRequest().isImportAccidentalCatch()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getAccidentalCatchFileResult();
            importFileResult.setSkipped(true);
        }
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import accidentalCatch.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.accidentalCatches", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getAccidentalCatchFileResult();
        try (CsvConsumerForAccidentalCatch consumer = this.importContext.loadAccidentalCatches(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext == null) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close accidentalCatch.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persistAccidentalBatches();
    }

    private void persistAccidentalBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    boolean override = fishingOperationContext.isOverride();
                    if (override) {
                        this.deleteAccidentalBatches(fishingOperationContext);
                    }
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    ImportAccidentalCatchAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.accidentalBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withAccidentalBatches()) continue;
                    Collection<AccidentalBatch> accidentalBatches = fishingOperationContext.getAccidentalBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + accidentalBatches.size() + " accidental batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    this.persistAccidentalBatches(accidentalBatches);
                }
            }

            private void deleteAccidentalBatches(GenericFormatImportOperationContext fishingOperationContext) {
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                ImportAccidentalCatchAction.this.persistenceHelper.deleteAccidentalBatchForFishingOperation(fishingOperation.getIdAsInt());
            }

            private void persistAccidentalBatches(Collection<AccidentalBatch> batches) {
                for (AccidentalBatch accidentalBatch : batches) {
                    Integer objectId = accidentalBatch.getIdAsInt();
                    Collection<AttachmentRow> attachmentRows = ImportAccidentalCatchAction.this.importContext.popAttachmentRows(ObjectTypeCode.SAMPLE, objectId);
                    accidentalBatch.setId((String)null);
                    AccidentalBatch createdAccidentalBatch = ImportAccidentalCatchAction.this.persistenceHelper.createAccidentalBatch(accidentalBatch);
                    ImportAccidentalCatchAction.this.persistenceHelper.persistAttachments(createdAccidentalBatch.getIdAsInt(), attachmentRows);
                }
            }
        });
    }
}

