/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class IndividualObservationBatchRowModel
extends AbstractTuttiBeanUIModel<IndividualObservationBatch, IndividualObservationBatchRowModel>
implements AttachmentModelAware,
IndividualObservationBatch,
CaracteristicMapColumnRowModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DEFAULT_CARACTERISTICS = "defaultCaracteristics";
    protected final IndividualObservationBatch editObject = IndividualObservationBatchs.newIndividualObservationBatch();
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected CaracteristicMap defaultCaracteristics = new CaracteristicMap();
    protected final WeightUnit weightUnit;
    protected static final Binder<IndividualObservationBatch, IndividualObservationBatchRowModel> fromBeanBinder = BinderFactory.newBinder(IndividualObservationBatch.class, IndividualObservationBatchRowModel.class);
    protected static final Binder<IndividualObservationBatchRowModel, IndividualObservationBatch> toBeanBinder = BinderFactory.newBinder(IndividualObservationBatchRowModel.class, IndividualObservationBatch.class);

    public IndividualObservationBatchRowModel(WeightUnit weightUnit, CaracteristicMap defaultCaracteristicMap) {
        super(fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
        if (this.getCaracteristics() == null) {
            this.setCaracteristics(new CaracteristicMap());
        }
        this.setDefaultCaracteristics(CaracteristicMap.copy(defaultCaracteristicMap));
    }

    public IndividualObservationBatchRowModel(WeightUnit weightUnit, Collection<Caracteristic> defaultCaracteristicsSet, IndividualObservationBatch entity) {
        this(weightUnit, CaracteristicMap.fromCollection(defaultCaracteristicsSet));
        this.fromEntity(entity);
    }

    public CaracteristicMap getDefaultCaracteristics() {
        return this.defaultCaracteristics;
    }

    public void setDefaultCaracteristics(CaracteristicMap defaultCaracteristics) {
        CaracteristicMap oldValue = CaracteristicMap.copy(this.getDefaultCaracteristics());
        this.defaultCaracteristics = defaultCaracteristics;
        this.firePropertyChange(PROPERTY_DEFAULT_CARACTERISTICS, oldValue, defaultCaracteristics);
    }

    @Override
    public void fromEntity(IndividualObservationBatch entity) {
        super.fromEntity(entity);
        this.setWeight(this.weightUnit.fromEntity(this.getWeight()));
        CaracteristicMap caracteristics = this.getCaracteristics();
        if (caracteristics == null) {
            this.setCaracteristics(new CaracteristicMap());
        } else {
            for (Caracteristic caracteristic : this.getDefaultCaracteristics().keySet()) {
                if (!caracteristics.containsKey(caracteristic)) continue;
                Serializable value = (Serializable)caracteristics.remove(caracteristic);
                this.defaultCaracteristics.put(caracteristic, value);
            }
        }
    }

    public static List<IndividualObservationBatchRowModel> fromEntity(WeightUnit weightUnit, Collection<Caracteristic> defaultCaracteristicsSet, List<IndividualObservationBatch> entities) {
        ArrayList result = Lists.newArrayList();
        for (IndividualObservationBatch entity : entities) {
            IndividualObservationBatchRowModel row = new IndividualObservationBatchRowModel(weightUnit, defaultCaracteristicsSet, entity);
            result.add(row);
        }
        return result;
    }

    @Override
    public IndividualObservationBatch toEntity() {
        Serializable value;
        IndividualObservationBatch result = (IndividualObservationBatch)super.toEntity();
        result.setWeight(this.weightUnit.toEntity(this.getWeight()));
        CaracteristicMap caracteristics = new CaracteristicMap();
        result.setCaracteristics(caracteristics);
        for (Map.Entry entry : this.getCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put((Caracteristic)entry.getKey(), value);
        }
        for (Map.Entry entry : this.getDefaultCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put((Caracteristic)entry.getKey(), value);
        }
        return result;
    }

    public static List<IndividualObservationBatch> toEntity(List<IndividualObservationBatchRowModel> rows, SpeciesBatch batch) {
        ArrayList result = Lists.newArrayList();
        for (IndividualObservationBatchRowModel row : rows) {
            IndividualObservationBatch entity = row.toEntity();
            entity.setBatchId(batch.getIdAsInt());
            entity.setFishingOperation(batch.getFishingOperation());
            entity.setSpecies(batch.getSpecies());
            result.add(entity);
        }
        return result;
    }

    @Override
    protected IndividualObservationBatch newEntity() {
        return IndividualObservationBatchs.newIndividualObservationBatch();
    }

    @Override
    public Integer getBatchId() {
        return this.editObject.getBatchId();
    }

    @Override
    public void setBatchId(Integer batchId) {
        this.editObject.setBatchId(batchId);
    }

    @Override
    public FishingOperation getFishingOperation() {
        return this.editObject.getFishingOperation();
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        this.editObject.setFishingOperation(fishingOperation);
    }

    @Override
    public Float getWeight() {
        return this.editObject.getWeight();
    }

    @Override
    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.editObject.setWeight(weight);
        this.firePropertyChange("weight", oldValue, weight);
    }

    public boolean withWeight() {
        return this.getWeight() != null;
    }

    @Override
    public Species getSpecies() {
        return this.editObject.getSpecies();
    }

    @Override
    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        this.editObject.setSpecies(species);
        this.firePropertyChange("species", oldValue, species);
    }

    @Override
    public Float getSize() {
        return this.editObject.getSize();
    }

    @Override
    public void setSize(Float size) {
        Float oldValue = this.getSize();
        this.editObject.setSize(size);
        this.firePropertyChange("size", oldValue, size);
    }

    public boolean withSize() {
        return this.getSize() != null;
    }

    @Override
    public Caracteristic getLengthStepCaracteristic() {
        return this.editObject.getLengthStepCaracteristic();
    }

    @Override
    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.editObject.setLengthStepCaracteristic(lengthStepCaracteristic);
        this.firePropertyChange("lengthStepCaracteristic", oldValue, lengthStepCaracteristic);
    }

    @Override
    public CaracteristicMap getCaracteristics() {
        return this.editObject.getCaracteristics();
    }

    @Override
    public void setCaracteristics(CaracteristicMap caracteristics) {
        CaracteristicMap oldValue = this.getCaracteristics();
        this.editObject.setCaracteristics(caracteristics);
        this.firePropertyChange("caracteristics", oldValue, caracteristics);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public Integer getRankOrder() {
        return this.editObject.getRankOrder();
    }

    @Override
    public void setRankOrder(Integer rankOrder) {
        this.editObject.setRankOrder(rankOrder);
    }

    @Override
    public String getSynchronizationStatus() {
        return this.editObject.getSynchronizationStatus();
    }

    @Override
    public void setSynchronizationStatus(String synchronizationStatus) {
        String oldValue = this.getSynchronizationStatus();
        this.editObject.setSynchronizationStatus(synchronizationStatus);
        this.firePropertyChange("synchronizationStatus", oldValue, synchronizationStatus);
    }

    @Override
    public CopyIndividualObservationMode getCopyIndividualObservationMode() {
        return this.editObject.getCopyIndividualObservationMode();
    }

    @Override
    public void setCopyIndividualObservationMode(CopyIndividualObservationMode copyIndividualObservationMode) {
        this.editObject.setCopyIndividualObservationMode(copyIndividualObservationMode);
    }

    @Override
    public String getSamplingCode() {
        return this.editObject.getSamplingCode();
    }

    @Override
    public void setSamplingCode(String samplingCode) {
        String oldValue = this.getSamplingCode();
        this.editObject.setSamplingCode(samplingCode);
        this.firePropertyChange("samplingCode", oldValue, samplingCode);
    }

    public Integer getSamplingCodeId() {
        return SamplingCodePrefix.extractSamplingCodeIdFromSamplingCode((String)this.getSamplingCode());
    }

    public boolean withSamplingCode() {
        return StringUtils.isNotBlank((CharSequence)this.getSamplingCode());
    }

    @Override
    public ObjectTypeCode getObjectType() {
        return ObjectTypeCode.SAMPLE;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public boolean isEmpty() {
        return this.isEmpty(Collections.emptySet());
    }

    public boolean isEmpty(Collection<Caracteristic> caracteristicsToIgnore) {
        return !(this.getSize() != null || this.getWeight() != null || this.getCaracteristics() != null && this.getCaracteristics().hasNonNullValues(caracteristicsToIgnore) || this.getDefaultCaracteristics() != null && this.getDefaultCaracteristics().hasNonNullValues(caracteristicsToIgnore) || !StringUtils.isBlank((CharSequence)this.getSamplingCode()) || this.getComment() != null || this.getAttachment() != null && !this.getAttachment().isEmpty());
    }

    public void copy(IndividualObservationBatchRowModel source) {
        this.setId(source.getId());
        this.setLengthStepCaracteristic(source.getLengthStepCaracteristic());
        this.setSize(source.getSize());
        this.setWeight(source.getWeight());
        this.setBatchId(source.getBatchId());
        this.setCaracteristics(source.getCaracteristics());
        this.setDefaultCaracteristics(source.getDefaultCaracteristics());
        this.setComment(source.getComment());
        this.setSamplingCode(source.getSamplingCode());
        this.setCopyIndividualObservationMode(source.getCopyIndividualObservationMode());
        this.addAllAttachment(source.getAttachment());
    }

    public CaracteristicQualitativeValue getCaracteristicQualitativeValue(Caracteristic caracteristic) {
        CaracteristicQualitativeValue result = null;
        if (caracteristic != null && (result = this.getCaracteristics().getQualitativeValue(caracteristic)) == null) {
            result = this.defaultCaracteristics.getQualitativeValue(caracteristic);
        }
        return result;
    }

    public boolean computeValid() {
        return this.computeValid(this.withSize(), this.withWeight());
    }

    public boolean computeValid(boolean withSize, boolean withWeight) {
        CopyIndividualObservationMode copyIndividualObservationMode = this.getCopyIndividualObservationMode();
        return copyIndividualObservationMode == CopyIndividualObservationMode.NOTHING || copyIndividualObservationMode == CopyIndividualObservationMode.SIZE && withSize || copyIndividualObservationMode == CopyIndividualObservationMode.ALL && withSize && withWeight;
    }
}

