/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveAccidentalBatchAction
extends LongActionSupport<AccidentalBatchUIModel, AccidentalBatchUI, AccidentalBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveAccidentalBatchAction.class);
    int rowIndex;

    public RemoveAccidentalBatchAction(AccidentalBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.editAccidentalBatch.action.removeBatch.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editAccidentalBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        boolean persisted;
        JXTable table = ((AccidentalBatchUIHandler)this.handler).getTable();
        this.rowIndex = table.getSelectedRow();
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if none is selected");
        AccidentalBatchTableModel tableModel = ((AccidentalBatchUIHandler)this.handler).getTableModel();
        AccidentalBatchRowModel selectedBatch = (AccidentalBatchRowModel)tableModel.getEntry(this.rowIndex);
        boolean bl = persisted = !TuttiEntities.isNew(selectedBatch);
        if (persisted) {
            String id = selectedBatch.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove accidental with id: " + id));
            }
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            persistenceService.deleteAccidentalBatch(id);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((AccidentalBatchUIHandler)this.handler).getTable();
        AccidentalBatchTableModel tableModel = ((AccidentalBatchUIHandler)this.handler).getTableModel();
        tableModel.removeRow(this.rowIndex);
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing((JXTable)table);
    }
}

