/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstab;
import org.eclipse.birt.report.item.crosstab.core.script.ILevel;
import org.eclipse.birt.report.item.crosstab.core.script.IMeasure;
import org.eclipse.birt.report.item.crosstab.core.script.internal.LevelImpl;
import org.eclipse.birt.report.item.crosstab.core.script.internal.MeasureImpl;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.SimpleRowItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabImpl
extends SimpleRowItem
implements ICrosstab {
    private CrosstabReportItemHandle crh;

    public CrosstabImpl(CrosstabReportItemHandle crh) {
        super((ExtendedItemHandle)crh.getModelHandle());
        this.crh = crh;
    }

    @Override
    public String getCaption() {
        return this.crh.getCaption();
    }

    @Override
    public void setCaption(String caption) throws SemanticException {
        this.crh.setCaption(caption);
    }

    @Override
    public String getCaptionKey() {
        return this.crh.getCaptionKey();
    }

    @Override
    public void setCaptionKey(String captionKey) throws SemanticException {
        this.crh.setCaptionKey(captionKey);
    }

    @Override
    public String getSummary() {
        return this.crh.getSummary();
    }

    @Override
    public void setSummary(String summary) throws SemanticException {
        this.crh.setSummary(summary);
    }

    @Override
    public List<ILevel> getColumnLevels() {
        ArrayList<LevelImpl> ms = new ArrayList<LevelImpl>();
        int i = 0;
        while (i < this.crh.getDimensionCount(1)) {
            DimensionViewHandle dv = this.crh.getDimension(1, i);
            int j = 0;
            while (j < dv.getLevelCount()) {
                ms.add(new LevelImpl(dv.getLevel(j)));
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableList(ms);
    }

    @Override
    public String getEmptyCellValue() {
        return this.crh.getEmptyCellValue();
    }

    @Override
    public String getMeasureDirection() {
        return this.crh.getMeasureDirection();
    }

    @Override
    public List<IMeasure> getMeasures() {
        ArrayList<MeasureImpl> ms = new ArrayList<MeasureImpl>();
        int i = 0;
        while (i < this.crh.getMeasureCount()) {
            ms.add(new MeasureImpl(this.crh.getMeasure(i)));
            ++i;
        }
        return Collections.unmodifiableList(ms);
    }

    @Override
    public List<ILevel> getRowLevels() {
        ArrayList<LevelImpl> ms = new ArrayList<LevelImpl>();
        int i = 0;
        while (i < this.crh.getDimensionCount(0)) {
            DimensionViewHandle dv = this.crh.getDimension(0, i);
            int j = 0;
            while (j < dv.getLevelCount()) {
                ms.add(new LevelImpl(dv.getLevel(j)));
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableList(ms);
    }

    @Override
    public boolean isRepeatColumnHeader() {
        return this.crh.isRepeatColumnHeader();
    }

    @Override
    public boolean isRepeatRowHeader() {
        return this.crh.isRepeatRowHeader();
    }

    @Override
    public void setEmptyCellValue(String value) throws SemanticException {
        this.crh.setEmptyCellValue(value);
    }

    @Override
    public void setMeasureDirection(String direction) throws SemanticException {
        this.crh.setMeasureDirection(direction);
    }

    @Override
    public void setRepeatColumnHeader(boolean value) throws SemanticException {
        this.crh.setRepeatColumnHeader(value);
    }

    @Override
    public void setRepeatRowHeader(boolean value) throws SemanticException {
        this.crh.setRepeatRowHeader(value);
    }

    @Override
    public int getRowPageBreakInterval() {
        return this.crh.getRowPageBreakInterval();
    }

    @Override
    public void setRowPageBreakInterval(int value) throws SemanticException {
        this.crh.setRowPageBreakInterval(value);
    }

    @Override
    public int getColumnPageBreakInterval() {
        return this.crh.getColumnPageBreakInterval();
    }

    @Override
    public void setColumnPageBreakInterval(int value) throws SemanticException {
        this.crh.setColumnPageBreakInterval(value);
    }
}

