/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.LookupSubtable;
import org.apache.batik.svggen.font.table.LookupSubtableFactory;

public class Lookup {
    public static final int IGNORE_BASE_GLYPHS = 2;
    public static final int IGNORE_BASE_LIGATURES = 4;
    public static final int IGNORE_BASE_MARKS = 8;
    public static final int MARK_ATTACHMENT_TYPE = 65280;
    private int type;
    private int flag;
    private int subTableCount;
    private int[] subTableOffsets;
    private LookupSubtable[] subTables;

    public Lookup(LookupSubtableFactory lookupSubtableFactory, RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.seek(n);
        this.type = randomAccessFile.readUnsignedShort();
        this.flag = randomAccessFile.readUnsignedShort();
        this.subTableCount = randomAccessFile.readUnsignedShort();
        this.subTableOffsets = new int[this.subTableCount];
        this.subTables = new LookupSubtable[this.subTableCount];
        int n2 = 0;
        while (n2 < this.subTableCount) {
            this.subTableOffsets[n2] = randomAccessFile.readUnsignedShort();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.subTableCount) {
            this.subTables[n3] = lookupSubtableFactory.read(this.type, randomAccessFile, n + this.subTableOffsets[n3]);
            ++n3;
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSubtableCount() {
        return this.subTableCount;
    }

    public LookupSubtable getSubtable(int n) {
        return this.subTables[n];
    }
}

