/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.tree;

import com.google.common.collect.Iterators;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeNodeSupport;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.OperationSelectTreeNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.tree.TreeNode;

public class CruiseSelectTreeNode
extends DataSelectTreeNodeSupport<CruiseDataModel>
implements Iterable<OperationSelectTreeNode> {
    private static final long serialVersionUID = 1L;
    private boolean selected;
    private final int nbChilds;
    private int nbChildSelected;
    private boolean objectValueIsAdjusting;

    public CruiseSelectTreeNode(CruiseDataModel userObject) {
        super(userObject);
        for (OperationDataModel operation : userObject) {
            OperationSelectTreeNode operationNode = new OperationSelectTreeNode(operation);
            this.add(operationNode);
        }
        this.nbChilds = userObject.size();
    }

    public boolean isPartialSelected() {
        return !this.selected && this.nbChildSelected > 0;
    }

    public int getNbChilds() {
        return this.nbChilds;
    }

    public int getNbChildSelected() {
        return this.nbChildSelected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelected(boolean selected) {
        this.objectValueIsAdjusting = true;
        this.selected = selected;
        try {
            for (OperationSelectTreeNode o : this) {
                o.setSelected(selected);
            }
        }
        finally {
            this.objectValueIsAdjusting = false;
        }
        this.updateSelectedSate();
    }

    @Override
    public CruiseDataModel getSelectedDataModel() {
        CruiseDataModel result;
        if (this.isSelected() || this.isPartialSelected()) {
            LinkedHashSet<OperationDataModel> operations = new LinkedHashSet<OperationDataModel>();
            for (OperationSelectTreeNode o : this) {
                OperationDataModel operation = o.getSelectedDataModel();
                if (operation == null) continue;
                operations.add(operation);
            }
            result = new CruiseDataModel(this.getId(), this.getLabel(), operations);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Iterator<OperationSelectTreeNode> iterator() {
        return Iterators.forEnumeration(this.children());
    }

    public void updateSelectedSate() {
        if (!this.objectValueIsAdjusting && this.nbChilds > 0) {
            this.nbChildSelected = 0;
            for (OperationSelectTreeNode o : this) {
                if (!o.isSelected()) continue;
                ++this.nbChildSelected;
            }
            if (this.selected) {
                if (this.nbChildSelected < this.nbChilds) {
                    this.selected = false;
                }
            } else if (this.nbChildSelected == this.nbChilds) {
                this.selected = true;
            }
        }
    }

    public boolean isSelectedDataExists() {
        boolean result = false;
        if (this.isSelected() || this.isPartialSelected()) {
            result = this.getOptionalId() != null;
        }
        return result;
    }

    public boolean isChildSelectedDataExists() {
        OperationSelectTreeNode o;
        TreeNode child;
        boolean result = false;
        int max = this.getChildCount();
        for (int i = 0; !(i >= max || (child = this.getChildAt(i)) instanceof OperationSelectTreeNode && (result = (o = (OperationSelectTreeNode)child).isSelectedDataExists())); ++i) {
        }
        return result;
    }
}

