/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.LocalDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceChooser;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceNotFoundException;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceServiceNotFoundException;
import fr.ifremer.tutti.ichtyometer.feed.IchtyometerFeedReader;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class ConnectIchtyometerAction
extends AbstractMainUITuttiAction {
    public ConnectIchtyometerAction(MainUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        IchtyometerClient client = new IchtyometerClient(this.getConfig().getIchtyometerMaximumNumberOfAttemptToConnect());
        RemoteDeviceChooser remoteDeviceChooser = remoteDeviceNames -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (String)JOptionPane.showInputDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.ichtyometer.choose.remote.device.found", (Object[])new Object[0]), I18n.t((String)"tutti.ichtyometer.title.choose.remote.device", (Object[])new Object[0]), 3, null, remoteDeviceNames.toArray(new String[remoteDeviceNames.size()]), null);
        };
        try {
            client.open(remoteDeviceChooser, this.getConfig().isFullBluetoothScan());
        }
        catch (LocalDeviceNotFoundException e) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.ichtyometer.error.no.local.device", (Object[])new Object[0]));
        }
        catch (RemoteDeviceNotFoundException e) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.ichtyometer.error.no.remote.device", (Object[])new Object[0]));
        }
        catch (RemoteDeviceServiceNotFoundException e) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.ichtyometer.error.no.remote.device.service", (Object[])new Object[0]));
        }
        IchtyometerFeedReader ichtyometerReader = new IchtyometerFeedReader();
        ichtyometerReader.start(client);
        this.getContext().setIchtyometerReader(ichtyometerReader);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        IchtyometerFeedReader ichtyometerReader = this.getContext().getIchtyometerReader();
        String clientName = ichtyometerReader.getClientName();
        this.sendMessage(I18n.t((String)"tutti.ichtyometer.connection.establish", (Object[])new Object[]{clientName}));
        this.displayInfoMessage(I18n.t((String)"tutti.ichtyometer.connection.establish.title", (Object[])new Object[0]), I18n.t((String)"tutti.ichtyometer.connection.establish.message", (Object[])new Object[]{clientName}));
    }
}

