/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GenericFormatFileResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final boolean mandatory;
    private final boolean found;
    private final Map<Long, Set<String>> errors;
    private boolean imported;
    private boolean skipped;

    public GenericFormatFileResult(String filename, boolean mandatory, boolean found) {
        this.filename = filename;
        this.mandatory = mandatory;
        this.found = found;
        this.errors = new LinkedHashMap<Long, Set<String>>();
    }

    public String getFilename() {
        return this.filename;
    }

    public Set<Map.Entry<Long, Set<String>>> getErrorsEntries() {
        return this.errors.entrySet();
    }

    public boolean isValid() {
        boolean result = !this.found ? !this.mandatory : this.isSkipped() || this.isImported() && this.errors.isEmpty();
        return result;
    }

    public void addGlobalError(String error) {
        Set<String> globalErrors = this.errors.get(0L);
        if (globalErrors == null) {
            globalErrors = new LinkedHashSet<String>();
            this.errors.put(0L, globalErrors);
        }
        globalErrors.add(error);
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public boolean isFound() {
        return this.found;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    protected Map<Long, Set<String>> getErrors() {
        return this.errors;
    }
}

