/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DesktopUtil {
    private static Log log = LogFactory.getLog(DesktopUtil.class);

    public static void browse(URI uri) {
        block7: {
            boolean useXdg = true;
            try {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    useXdg = false;
                    desktop.browse(uri);
                }
            }
            catch (IOException desktop) {
                // empty catch block
            }
            if (useXdg) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Desktop API not supported, launching xdg-open");
                }
                ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                try {
                    pb.start();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Could not launch browser, there is maybe no default browser configured on the system", (Throwable)e);
                }
            }
        }
    }

    public static void open(File file) {
        block7: {
            boolean useXdg = true;
            try {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                    useXdg = false;
                    desktop.open(file);
                }
            }
            catch (IOException desktop) {
                // empty catch block
            }
            if (useXdg) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Desktop API not supported, launching xdg-open");
                }
                ProcessBuilder pb = new ProcessBuilder("xdg-open", file.toURI().toString());
                try {
                    pb.start();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Could not open file, there is maybe no default viewer configured on the system", (Throwable)e);
                }
            }
        }
    }

    public static void mail(URI uri) {
        block7: {
            boolean useXdg = true;
            try {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
                    useXdg = false;
                    desktop.mail(uri);
                }
            }
            catch (IOException desktop) {
                // empty catch block
            }
            if (useXdg) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Desktop API not supported, launching xdg-open");
                }
                ProcessBuilder pb = new ProcessBuilder("xdg-email", uri.toString());
                try {
                    pb.start();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Could not open file, there is maybe no default viewer configured on the system", (Throwable)e);
                }
            }
        }
    }
}

