/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.report;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.report.ReportGenerationService;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class ReportUIHandler
extends AbstractTuttiUIHandler<ReportUIModel, ReportUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ReportUIHandler.class);

    public void beforeInit(ReportUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ReportGenerationService reportService = this.getContext().getReportGenerationService();
        ReportUIModel model = new ReportUIModel();
        String programId = this.getDataContext().getProgramId();
        model.setProgramId(programId);
        Integer cruiseId = this.getDataContext().getCruiseId();
        model.setCruiseId(cruiseId);
        List reports = reportService.getAvailableReports();
        model.setReports(reports);
        List fishingOperations = this.getContext().getPersistenceService().getAllFishingOperation(cruiseId);
        model.setFishingOperations(fishingOperations);
        this.listModelIsModify(model);
        model.addPropertyChangeListener(new PropertyChangeListener(){
            Set<String> removeReportProperties = ImmutableSet.of((Object)"fishingOperation", (Object)"report");

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReportUIModel source = (ReportUIModel)evt.getSource();
                if (source.isReportDone() && this.removeReportProperties.contains(evt.getPropertyName())) {
                    source.setReportGenerationResult(null);
                }
            }
        });
        ui.setContextValue(model);
    }

    public void afterInit(ReportUI ui) {
        this.initUI(ui);
        ReportUIModel model = (ReportUIModel)this.getModel();
        this.initBeanFilterableComboBox(ui.getReportComboBox(), Lists.newArrayList(model.getReports()), model.getReport());
        this.initBeanFilterableComboBox(ui.getFishingOperationComboBox(), Lists.newArrayList(model.getFishingOperations()), model.getFishingOperation());
        SwingValidator<ReportUIModel> validator = ui.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
    }

    protected JComponent getComponentToFocus() {
        return ((ReportUI)this.getUI()).getFishingOperationComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public boolean quitUI() {
        return true;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return ((ReportUI)this.ui).getValidator();
    }
}

