/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones.actions;

import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.ZoneEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DeleteZoneAction
extends SimpleActionSupport<ZoneEditorUI> {
    private static final Log log = LogFactory.getLog(DeleteZoneAction.class);

    public DeleteZoneAction(ZoneEditorUI zoneEditorUI) {
        super(zoneEditorUI);
    }

    @Override
    protected void onActionPerformed(ZoneEditorUI zoneEditorUI) {
        JTree zonesTree = zoneEditorUI.getZonesTree();
        if (zonesTree.getSelectionCount() == 1) {
            TreePath selectedPath = zonesTree.getSelectionPath();
            ZoneNode zoneNode = (ZoneNode)selectedPath.getPathComponent(1);
            String zoneLabel = zoneNode.getUserObject();
            int confirmDeletion = JOptionPane.showConfirmDialog((Component)((Object)zoneEditorUI), I18n.t((String)"tutti.zoneEditor.deleteZone.message", (Object[])new Object[]{zoneLabel}), I18n.t((String)"tutti.zoneEditor.deleteZone.title", (Object[])new Object[0]), 0, 3);
            if (confirmDeletion == 0) {
                EditProtocolUIModel model = zoneEditorUI.getModel();
                Enumeration<TreeNode> children = zoneNode.children();
                while (children.hasMoreElements()) {
                    StrataNode strateNode = (StrataNode)children.nextElement();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Move back strata: " + strateNode + " to available universe."));
                    }
                    model.unselectStrataNode(strateNode);
                }
                model.getZonesTreeModel().removeNodeFromParent(zoneNode);
            }
        }
    }
}

