/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import fr.ifremer.tutti.caliper.feed.CaliperConnectionException;
import fr.ifremer.tutti.caliper.feed.CaliperFeedReader;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class ConnectCaliperAction
extends AbstractMainUITuttiAction {
    public ConnectCaliperAction(MainUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        CaliperFeedReader caliperReader = new CaliperFeedReader();
        int caliperSerialPort = this.getConfig().getCaliperSerialPort();
        try {
            caliperReader.start(caliperSerialPort);
        }
        catch (CaliperConnectionException e) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.caliper.connection.error", (Object[])new Object[]{caliperSerialPort, e.getMessage()}));
        }
        this.getContext().setCaliperReader(caliperReader);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        CaliperFeedReader caliperReader = this.getContext().getCaliperReader();
        String serialPort = caliperReader.getSerialPortName();
        this.sendMessage(I18n.t((String)"tutti.caliper.connection.establish", (Object[])new Object[]{serialPort}));
        this.displayInfoMessage(I18n.t((String)"tutti.caliper.connection.establish.title", (Object[])new Object[0]), I18n.t((String)"tutti.caliper.connection.establish.message", (Object[])new Object[]{serialPort}));
    }
}

