/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.AbstractCruises;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Cruises
extends AbstractCruises {
    public static Comparator<Cruise> CRUISE_COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());

    public static boolean isDirty(Cruise cruise) {
        String synchronizationStatus = cruise.getSynchronizationStatus();
        return SynchronizationStatus.DIRTY.getValue().equals(synchronizationStatus);
    }

    public static boolean isReadyToSynch(Cruise cruise) {
        String synchronizationStatus = cruise.getSynchronizationStatus();
        return SynchronizationStatus.READY_TO_SYNCHRONIZE.getValue().equals(synchronizationStatus);
    }

    public static boolean isSynch(Cruise cruise) {
        String synchronizationStatus = cruise.getSynchronizationStatus();
        return SynchronizationStatus.SYNCHRONIZED.getValue().equals(synchronizationStatus);
    }

    public static boolean equalsNaturalId(Cruise cruise1, String naturalId2) {
        String naturalId1 = Cruises.getNaturalId(cruise1);
        return Objects.equals(naturalId1, naturalId2);
    }

    public static boolean equals(Cruise cruise1, Cruise cruise2) {
        String surveyPart2;
        int year2;
        int year1;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        Calendar instance = Calendar.getInstance();
        if (cruise1.getBeginDate() == null) {
            year1 = -1;
        } else {
            instance.setTime(cruise1.getBeginDate());
            year1 = instance.get(1);
        }
        if (cruise1.getBeginDate() == null) {
            year2 = -2;
        } else {
            instance.setTime(cruise2.getBeginDate());
            year2 = instance.get(1);
        }
        equalsBuilder.append(year1, year2);
        String surveyPart1 = cruise1.getSurveyPart();
        if (surveyPart1 == null) {
            surveyPart1 = "";
        }
        if ((surveyPart2 = cruise2.getSurveyPart()) == null) {
            surveyPart2 = "";
        }
        equalsBuilder.append((Object)surveyPart1, (Object)surveyPart2);
        equalsBuilder.append((Object)cruise1.getProgram(), (Object)cruise2.getProgram());
        return equalsBuilder.isEquals();
    }

    public static String getNaturalId(Cruise cruise) {
        int year1;
        Calendar instance = Calendar.getInstance();
        if (cruise.getBeginDate() == null) {
            year1 = -1;
        } else {
            instance.setTime(cruise.getBeginDate());
            year1 = instance.get(1);
        }
        String surveyPart1 = cruise.getSurveyPart();
        if (surveyPart1 == null) {
            surveyPart1 = "";
        }
        String programId = cruise.getProgram().getId();
        return year1 + "--" + surveyPart1 + "--" + programId;
    }

    public static void sort(List<Cruise> cruises) {
        Collections.sort(cruises, CRUISE_COMPARATOR);
    }
}

