/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.util.Objects;

public class IndividualObservationSamplingContext {
    private final Species species;
    private final Integer lengthStep;
    private final Boolean maturity;
    private final CaracteristicQualitativeValue gender;
    private final CalcifiedPiecesSamplingDefinition calcifiedPiecesSamplingDefinition;
    private final Zone zone;
    private final String cruiseSamplingKey;
    private final String zoneSamplingKey;
    private final String fishingOperationSamplingKey;

    public IndividualObservationSamplingContext(Species species, Integer lengthStep, Boolean maturity, CaracteristicQualitativeValue gender, CalcifiedPiecesSamplingDefinition calcifiedPiecesSamplingDefinition, Zone zone, String cruiseSamplingKey, String zoneSamplingKey, String fishingOperationSamplingKey) {
        Objects.requireNonNull(species);
        Objects.requireNonNull(calcifiedPiecesSamplingDefinition);
        Objects.requireNonNull(zone);
        Objects.requireNonNull(cruiseSamplingKey);
        Objects.requireNonNull(zoneSamplingKey);
        Objects.requireNonNull(fishingOperationSamplingKey);
        this.species = species;
        this.lengthStep = lengthStep;
        this.maturity = maturity;
        this.gender = gender;
        this.calcifiedPiecesSamplingDefinition = calcifiedPiecesSamplingDefinition;
        this.zone = zone;
        this.cruiseSamplingKey = cruiseSamplingKey;
        this.zoneSamplingKey = zoneSamplingKey;
        this.fishingOperationSamplingKey = fishingOperationSamplingKey;
    }

    public Species getSpecies() {
        return this.species;
    }

    public Integer getLengthStep() {
        return this.lengthStep;
    }

    public Boolean getMaturity() {
        return this.maturity;
    }

    public CaracteristicQualitativeValue getGender() {
        return this.gender;
    }

    public CalcifiedPiecesSamplingDefinition getCalcifiedPiecesSamplingDefinition() {
        return this.calcifiedPiecesSamplingDefinition;
    }

    public Zone getZone() {
        return this.zone;
    }

    public int getTotalSamplingRequiredInCruise() {
        return this.calcifiedPiecesSamplingDefinition.getMaxByLenghtStep();
    }

    public int getTotalSamplingRequiredInFishingOperation() {
        return this.calcifiedPiecesSamplingDefinition.getOperationLimitation();
    }

    public int getTotalSamplingRequiredInZone() {
        return this.calcifiedPiecesSamplingDefinition.getZoneLimitation();
    }

    public String getCruiseSamplingKey() {
        return this.cruiseSamplingKey;
    }

    public String getZoneSamplingKey() {
        return this.zoneSamplingKey;
    }

    public String getFishingOperationSamplingKey() {
        return this.fishingOperationSamplingKey;
    }

    public boolean withGender() {
        return this.gender != null;
    }

    public boolean withMaturity() {
        return this.maturity != null;
    }
}

