/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.protocol.Rtps;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.ForeignKeyParserFormatter;
import fr.ifremer.tutti.service.csv.StringParserFormatter;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.protocol.SpeciesRow;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.nuiton.csv.Common;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.i18n.I18n;

public class SpeciesRowModel
extends AbstractTuttiImportExportModel<SpeciesRow> {
    public static SpeciesRowModel forExport(char separator) {
        SpeciesRowModel result = new SpeciesRowModel(separator);
        result.newColumnForExport("speciesReferenceTaxonId", (ValueFormatter)Common.INTEGER);
        result.newColumnForExport("speciesRefTaxCode");
        result.newColumnForExport("speciesName");
        result.newColumnForExport("speciesSurveyCode");
        result.newColumnForExport("lengthStepPmfmId");
        result.newColumnForExport("lengthStepPmfmParameterName");
        result.newColumnForExport("lengthStepPmfmMatrixName");
        result.newColumnForExport("lengthStepPmfmFractionName");
        result.newColumnForExport("lengthStepPmfmMethodName");
        result.newColumnForExport("mandatorySampleCategoryId", (ValueFormatter)TuttiCsvUtil.INTEGER_LIST_PARSER_FORMATTER);
        result.newColumnForExport("weightEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        result.newColumnForExport("rtpMaleA", (ValueFormatter)Common.DOUBLE);
        result.newColumnForExport("rtpMaleB", (ValueFormatter)Common.FLOAT);
        result.newColumnForExport("rtpFemaleA", (ValueFormatter)Common.DOUBLE);
        result.newColumnForExport("rtpFemaleB", (ValueFormatter)Common.FLOAT);
        result.newColumnForExport("rtpUndefinedA", (ValueFormatter)Common.DOUBLE);
        result.newColumnForExport("rtpUndefinedB", (ValueFormatter)Common.FLOAT);
        return result;
    }

    public static SpeciesRowModel forImport(char separator, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        SpeciesRowModel result = new SpeciesRowModel(separator);
        result.newMandatoryColumn("speciesReferenceTaxonId", "species", (ValueParser)new ForeignKeyParserFormatter<Species>(Species.class, "referenceTaxonId", speciesMap){
            Set<Integer> taxonIds = Sets.newHashSet();

            @Override
            public Species parse(String value) throws ParseException {
                Species species = (Species)super.parse(value);
                Integer referenceTaxonId = species.getReferenceTaxonId();
                if (this.taxonIds.contains(referenceTaxonId)) {
                    throw new ImportRuntimeException(I18n.t((String)"tutti.service.protocol.import.taxonUsed.error", (Object[])new Object[]{referenceTaxonId}));
                }
                this.taxonIds.add(referenceTaxonId);
                return species;
            }
        });
        result.newOptionalColumn("speciesRefTaxCode");
        result.newOptionalColumn("speciesName");
        result.newForeignKeyColumn("lengthStepPmfmId", "lengthStepPmfm", Caracteristic.class, "id", caracteristicMap);
        result.newIgnoredColumn("lengthStepPmfmParameterName");
        result.newIgnoredColumn("lengthStepPmfmMatrixName");
        result.newIgnoredColumn("lengthStepPmfmFractionName");
        result.newIgnoredColumn("lengthStepPmfmMethodName");
        result.newIgnoredColumn("calcifySampleEnabled");
        result.newIgnoredColumn("countIfNoFrequencyEnabled");
        result.newMandatoryColumn("speciesSurveyCode", (ValueParser)new StringParserFormatter(null, true));
        result.newMandatoryColumn("mandatorySampleCategoryId", (ValueParser)TuttiCsvUtil.INTEGER_LIST_PARSER_FORMATTER);
        result.newMandatoryColumn("weightEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        result.newOptionalColumn("rtpMaleA", (ValueParser)Common.DOUBLE);
        result.newOptionalColumn("rtpMaleB", (ValueParser)Common.FLOAT);
        result.newOptionalColumn("rtpFemaleA", (ValueParser)Common.DOUBLE);
        result.newOptionalColumn("rtpFemaleB", (ValueParser)Common.FLOAT);
        result.newOptionalColumn("rtpUndefinedA", (ValueParser)Common.DOUBLE);
        result.newOptionalColumn("rtpUndefinedB", (ValueParser)Common.FLOAT);
        return result;
    }

    public SpeciesRowModel(char separator) {
        super(separator);
    }

    public SpeciesRow newEmptyInstance() {
        SpeciesRow speciesRow = new SpeciesRow();
        speciesRow.setRtpMale(Rtps.newRtp());
        speciesRow.setRtpFemale(Rtps.newRtp());
        speciesRow.setRtpUndefined(Rtps.newRtp());
        return speciesRow;
    }
}

