/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.io.Files;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import fr.ifremer.tutti.service.catches.multipost.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterRowModel;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class MultiPostExportContext
implements MultiPostConstants,
Closeable {
    private final File targetFile;
    private final File temporaryDirectory;
    private final PersistenceService persistenceService;
    private final List<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
    private final Map<Integer, String> speciesOrBenthosIdTranslations = new TreeMap<Integer, String>();
    private final List<CatchRow> speciesOrBenthosRows = new ArrayList<CatchRow>();
    private final List<CatchFrequencyRow> frequencyRows = new ArrayList<CatchFrequencyRow>();
    private final List<AccidentalCatchRow> accidentialCatchRows = new ArrayList<AccidentalCatchRow>();
    private final List<MarineLitterRow> marineLitterRows = new ArrayList<MarineLitterRow>();
    private final List<IndividualObservationRow> individualObservationRows = new ArrayList<IndividualObservationRow>();
    private final List<CaracteristicRow> caracteristicRows = new ArrayList<CaracteristicRow>();
    private final List<File> file2zip = new ArrayList<File>();

    public MultiPostExportContext(File targetFile, PersistenceService persistenceService) {
        this.targetFile = targetFile;
        this.temporaryDirectory = Files.createTempDir();
        this.persistenceService = persistenceService;
    }

    public void addAttachments(String batchId, int objectId, ObjectTypeCode objectType) {
        List<Attachment> attachments = this.persistenceService.getAllAttachments(objectType, objectId);
        for (Attachment attachment : attachments) {
            AttachmentRow attachmentRow = new AttachmentRow();
            attachmentRow.setBatchId(batchId);
            attachmentRow.setName(attachment.getName());
            attachmentRow.setComment(attachment.getComment());
            attachmentRow.setFile(this.persistenceService.getAttachmentFile(attachment.getId()));
            this.attachmentRows.add(attachmentRow);
        }
    }

    public void storeSpeciesOrBenthosBatches(String fileName, boolean exportFrequencies, boolean exportIndividualObservations) {
        this.export(fileName, (ExportModel)CatchRowModel.forExport(), (List)this.speciesOrBenthosRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        if (exportFrequencies) {
            this.storeFrequencies();
        }
        if (exportIndividualObservations) {
            this.storeIndividualObservations();
        }
    }

    public void storeFrequencies() {
        this.export("frequencies.csv", (ExportModel)CatchFrequencyRowModel.forExport(), (List)this.frequencyRows, I18n.n((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[0]));
    }

    public void storeIndividualObservations() {
        this.export("individualObservation.csv", (ExportModel)IndividualObservationRowModel.forExport(), (List)this.individualObservationRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        this.export("caracteristics.csv", (ExportModel)CaracteristicRowModel.forExport(), (List)this.caracteristicRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
    }

    public void storeAttachments() {
        AttachmentRowModel csvAttachmentModel = AttachmentRowModel.forExport();
        File attachmentDirectory = new File(this.temporaryDirectory, "attachments");
        ApplicationIOUtil.forceMkdir((File)attachmentDirectory, (String)I18n.t((String)"tutti.service.multipost.attachment.mkdir.error", (Object[])new Object[]{attachmentDirectory}));
        this.addFile(attachmentDirectory);
        for (AttachmentRow attachmentRow : this.attachmentRows) {
            File attachmentFile = attachmentRow.getFile();
            File destFile = new File(attachmentDirectory, attachmentFile.getName());
            ApplicationIOUtil.copyFile((File)attachmentFile, (File)destFile, (String)I18n.t((String)"tutti.service.multipost.attachment.copy.error", (Object[])new Object[]{attachmentFile}));
            this.addFile(destFile);
        }
        this.export("attachments.csv", (ExportModel)csvAttachmentModel, (List)this.attachmentRows, I18n.n((String)"tutti.service.multipost.export.attachments.error", (Object[])new Object[0]));
    }

    @Override
    public void close() {
        this.storeAttachments();
        try {
            ApplicationIOUtil.zip((File)this.temporaryDirectory, (File)this.targetFile, this.file2zip, (String)I18n.n((String)"tutti.service.multipost.export.error", (Object[])new Object[0]));
        }
        catch (Throwable throwable) {
            ApplicationIOUtil.deleteDirectory((File)this.temporaryDirectory, (String)I18n.t((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{this.targetFile}));
            throw throwable;
        }
        ApplicationIOUtil.deleteDirectory((File)this.temporaryDirectory, (String)I18n.t((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{this.targetFile}));
    }

    public void addSpeciesOrBenthosBatch(String batchId, String parentId, SpeciesBatch batch) {
        CatchRow row = new CatchRow();
        row.setId(batchId);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        this.speciesOrBenthosRows.add(row);
        this.speciesOrBenthosIdTranslations.put(batch.getIdAsInt(), batchId);
        this.addAttachments(batchId, batch.getIdAsInt(), ObjectTypeCode.BATCH);
    }

    public void addFrequencies(String rowId, List<SpeciesBatchFrequency> frequencies) {
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(rowId);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRow.setSpecies(frequency.getBatch().getSpecies());
            this.frequencyRows.add(frequencyRow);
        }
    }

    public void addIndividualObservations(String batchId, IndividualObservationBatch batch) {
        IndividualObservationRow row = new IndividualObservationRow();
        row.setBatchId(batchId);
        String speciesOrBenthosBatchId = this.speciesOrBenthosIdTranslations.get(batch.getBatchId());
        row.setSpeciesBatchId(speciesOrBenthosBatchId);
        row.setSpecies(batch.getSpecies());
        row.setWeight(batch.getWeight());
        row.setSize(batch.getSize());
        row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
        row.setSamplingCode(batch.getSamplingCode());
        row.setComment(batch.getComment());
        row.setCopyIndividualObservationMode(batch.getCopyIndividualObservationMode());
        this.individualObservationRows.add(row);
        this.addCaracteristics(batchId, batch.getCaracteristics());
        this.addAttachments(batchId, batch.getIdAsInt(), ObjectTypeCode.SAMPLE);
    }

    public void addMarineLitterBatch(String batchId, MarineLitterBatch batch) {
        MarineLitterRow row = new MarineLitterRow();
        row.setBatchId(batchId);
        row.setCategory(batch.getMarineLitterCategory());
        row.setSizeCategory(batch.getMarineLitterSizeCategory());
        row.setNumber(batch.getNumber());
        row.setWeight(batch.getWeight());
        row.setComment(batch.getComment());
        this.marineLitterRows.add(row);
        this.addAttachments(batchId, batch.getIdAsInt(), ObjectTypeCode.BATCH);
    }

    public void addAccidentalCatch(String batchId, AccidentalBatch batch) {
        AccidentalCatchRow row = new AccidentalCatchRow();
        row.setBatchId(batchId);
        row.setSpecies(batch.getSpecies());
        row.setGender(batch.getGender());
        row.setWeight(batch.getWeight());
        row.setSize(batch.getSize());
        row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
        row.setDeadOrAlive(batch.getDeadOrAlive());
        row.setComment(batch.getComment());
        this.accidentialCatchRows.add(row);
        this.addCaracteristics(batchId, batch.getCaracteristics());
        this.addAttachments(batchId, batch.getIdAsInt(), ObjectTypeCode.SAMPLE);
    }

    public <R> void export(String fileName, ExportModel<R> exportModel, List<R> rows, String errorMessage) {
        File file = new File(this.temporaryDirectory, fileName);
        this.addFile(file);
        try (Writer writer = ApplicationIOUtil.newWriter((File)file, (String)I18n.n((String)"tutti.service.multipost.export.file.writer.error", (Object[])new Object[0]));){
            Export export = Export.newExport(exportModel, rows);
            export.write(writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)errorMessage, (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public void storeAccidentalCatches() {
        this.export("accidentalCatches.csv", (ExportModel)AccidentalCatchRowModel.forExport(), (List)this.accidentialCatchRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        this.export("caracteristics.csv", (ExportModel)CaracteristicRowModel.forExport(), (List)this.caracteristicRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
    }

    public void storeMarineLitterBatches() {
        this.export("marineLitter.csv", (ExportModel)MarineLitterRowModel.forExport(), (List)this.marineLitterRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
    }

    protected void addFile(File file) {
        this.file2zip.add(file);
    }

    protected void addCaracteristics(String batchId, CaracteristicMap caracteristicMap) {
        for (Caracteristic caracteristic : caracteristicMap.keySet()) {
            CaracteristicRow caracteristicRow = new CaracteristicRow();
            caracteristicRow.setBatchId(batchId);
            caracteristicRow.setCaracteristic(caracteristic);
            caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
            this.caracteristicRows.add(caracteristicRow);
        }
    }
}

