/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinitions;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.protocol.CalcifiedPiecesSamplingRow;
import fr.ifremer.tutti.service.protocol.CalcifiedPiecesSamplingRowModel;
import fr.ifremer.tutti.service.protocol.SpeciesRow;
import fr.ifremer.tutti.service.protocol.SpeciesRowModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ProtocolImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ProtocolImportExportService.class);

    public void exportProtocol(TuttiProtocol protocol, File file) {
        TuttiProtocols.toFile((TuttiProtocol)protocol, (File)file);
    }

    public TuttiProtocol importProtocol(File file) {
        return TuttiProtocols.fromFile((File)file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Species> importProtocolSpecies(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol [" + protocol.getName() + "] species from file: " + file));
        }
        ArrayList<Species> result = new ArrayList<Species>();
        LinkedHashMap<Integer, Object> ids = new LinkedHashMap<Integer, Object>();
        if (!protocol.isSpeciesEmpty()) {
            for (Object speciesProtocol : protocol.getSpecies()) {
                ids.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        LinkedHashMap<Integer, SpeciesProtocol> benthosIds = new LinkedHashMap<Integer, SpeciesProtocol>();
        if (!protocol.isBenthosEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                benthosIds.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            SpeciesRowModel csvModel = SpeciesRowModel.forImport(this.getCsvSeparator(), caracteristicMap, speciesMap);
            Serializable serializable = null;
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                Binder binder = BinderFactory.newBinder(SpeciesRow.class, SpeciesProtocol.class);
                for (SpeciesRow bean : importer) {
                    Species species = bean.getSpecies();
                    Integer id = species.getReferenceTaxonId();
                    SpeciesProtocol sp = (SpeciesProtocol)benthosIds.get(id);
                    if (sp != null) {
                        result.add(species);
                        continue;
                    }
                    sp = (SpeciesProtocol)ids.get(id);
                    if (sp == null) {
                        sp = SpeciesProtocols.newSpeciesProtocol();
                    }
                    binder.copy((Object)bean, (Object)sp, new String[0]);
                    sp.setMandatorySampleCategoryId(new ArrayList<Integer>(bean.getMandatorySampleCategoryId()));
                    this.cleanRptData(sp);
                    ids.put(id, sp);
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            ArrayList values = new ArrayList(ids.values());
            protocol.setSpecies(values);
            serializable = result;
            return serializable;
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.import.species.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
    }

    public List<Species> importProtocolBenthos(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol [" + protocol.getName() + "] species from file: " + file));
        }
        ArrayList<Species> result = new ArrayList<Species>();
        LinkedHashMap<Integer, Object> ids = new LinkedHashMap<Integer, Object>();
        if (!protocol.isBenthosEmpty()) {
            for (Object speciesProtocol : protocol.getBenthos()) {
                ids.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        LinkedHashMap<Integer, SpeciesProtocol> speciesIds = new LinkedHashMap<Integer, SpeciesProtocol>();
        if (!protocol.isSpeciesEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                speciesIds.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            SpeciesRowModel csvModel = SpeciesRowModel.forImport(this.getCsvSeparator(), caracteristicMap, speciesMap);
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                Binder binder = BinderFactory.newBinder(SpeciesRow.class, SpeciesProtocol.class);
                for (SpeciesRow bean : importer) {
                    Species species = bean.getSpecies();
                    Integer id = species.getReferenceTaxonId();
                    SpeciesProtocol sp = (SpeciesProtocol)speciesIds.get(id);
                    if (sp != null) {
                        result.add(species);
                        continue;
                    }
                    sp = (SpeciesProtocol)ids.get(id);
                    if (sp == null) {
                        sp = SpeciesProtocols.newSpeciesProtocol();
                    }
                    binder.copy((Object)bean, (Object)sp, new String[0]);
                    this.cleanRptData(sp);
                    ids.put(id, sp);
                }
                ArrayList values = new ArrayList(ids.values());
                protocol.setBenthos(values);
            }
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.import.benthos.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
        return result;
    }

    public void exportProtocolSpecies(File file, List<SpeciesProtocol> protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export species to file: " + file));
        }
        List rows = CollectionUtils.isEmpty(protocol) ? null : protocol.stream().map(new SpeciesProtocolToSpeciesRowFunction(caracteristicMap, speciesMap)).collect(Collectors.toList());
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            SpeciesRowModel csvModel = SpeciesRowModel.forExport(this.getCsvSeparator());
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public void exportProtocolBenthos(File file, List<SpeciesProtocol> protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export benthos to file: " + file));
        }
        List rows = CollectionUtils.isEmpty(protocol) ? null : protocol.stream().map(new SpeciesProtocolToSpeciesRowFunction(caracteristicMap, speciesMap)).collect(Collectors.toList());
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            SpeciesRowModel csvModel = SpeciesRowModel.forExport(this.getCsvSeparator());
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.benthos.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public Set<Species> importCalcifiedPiecesSamplings(File file, TuttiProtocol protocol, Map<String, Species> allSpecies) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol [" + protocol.getName() + "] cps from file: " + file));
        }
        HashSet<Species> result = new HashSet<Species>();
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            CalcifiedPiecesSamplingRowModel csvModel = CalcifiedPiecesSamplingRowModel.forImport(this.getCsvSeparator(), allSpecies);
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                Binder binder = BinderFactory.newBinder(CalcifiedPiecesSamplingRow.class, CalcifiedPiecesSamplingDefinition.class);
                Map<Integer, SpeciesProtocol> availableSpeciesProtocolMap = this.availableSpeciesProtocolMap(protocol);
                ArrayListMultimap calcifiedPiecesSamplingDefinitionsWithoutMaturity = ArrayListMultimap.create();
                ArrayListMultimap calcifiedPiecesSamplingDefinitionsWithTrueMaturity = ArrayListMultimap.create();
                ArrayListMultimap calcifiedPiecesSamplingDefinitionsWithFalseMaturity = ArrayListMultimap.create();
                LinkedHashSet<SpeciesProtocol> speciesProtocolsWithAndWithoutMaturity = new LinkedHashSet<SpeciesProtocol>();
                for (CalcifiedPiecesSamplingRow bean : importer) {
                    ArrayListMultimap calcifiedPiecesSamplingDefinitions;
                    Species species = bean.getSpecies();
                    if (result.contains(species)) continue;
                    SpeciesProtocol speciesProtocol2 = availableSpeciesProtocolMap.get(species.getReferenceTaxonId());
                    if (speciesProtocol2 == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Skip species: " + species + ", not found in protocol."));
                        }
                        result.add(species);
                        continue;
                    }
                    if (speciesProtocol2.getLengthStepPmfmId() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Skip species: " + species + ", found in protocol, but with no length class."));
                        }
                        result.add(species);
                        continue;
                    }
                    CalcifiedPiecesSamplingDefinition definition = CalcifiedPiecesSamplingDefinitions.newCalcifiedPiecesSamplingDefinition((Object)bean, (Binder)binder);
                    Boolean maturity = definition.getMaturity();
                    if (maturity == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("On species: " + species + ", add definition with no maturity defined (" + definition + ")"));
                        }
                        calcifiedPiecesSamplingDefinitions = calcifiedPiecesSamplingDefinitionsWithoutMaturity;
                        if (calcifiedPiecesSamplingDefinitionsWithTrueMaturity.containsKey((Object)speciesProtocol2) || calcifiedPiecesSamplingDefinitionsWithFalseMaturity.containsKey((Object)speciesProtocol2)) {
                            speciesProtocolsWithAndWithoutMaturity.add(speciesProtocol2);
                        }
                    } else {
                        if (calcifiedPiecesSamplingDefinitionsWithoutMaturity.containsKey((Object)speciesProtocol2)) {
                            speciesProtocolsWithAndWithoutMaturity.add(speciesProtocol2);
                        }
                        if (maturity.booleanValue()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("On species: " + species + ", add definition with maturity defined to True (" + definition + ")"));
                            }
                            calcifiedPiecesSamplingDefinitions = calcifiedPiecesSamplingDefinitionsWithTrueMaturity;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("On species: " + species + ", add definition with maturity defined to False (" + definition + ")"));
                            }
                            calcifiedPiecesSamplingDefinitions = calcifiedPiecesSamplingDefinitionsWithFalseMaturity;
                        }
                    }
                    calcifiedPiecesSamplingDefinitions.put((Object)speciesProtocol2, (Object)definition);
                }
                if (!speciesProtocolsWithAndWithoutMaturity.isEmpty()) {
                    String badSpecies = speciesProtocolsWithAndWithoutMaturity.stream().map(speciesProtocol -> {
                        String speciesToString = speciesProtocol.getSpeciesReferenceTaxonId() + "";
                        if (speciesProtocol.getSpeciesSurveyCode() != null) {
                            speciesToString = speciesToString + " (" + speciesProtocol.getSpeciesSurveyCode() + " )";
                        }
                        return speciesToString;
                    }).collect(Collectors.joining("", "<li>", "</li>"));
                    throw new ImportRuntimeException(I18n.t((String)"tutti.service.protocol.import.cps.speciesWithMaturityAndWithoutMaturity.error", (Object[])new Object[]{badSpecies}));
                }
                Comparator<CalcifiedPiecesSamplingDefinition> definitionsComparator = Comparator.comparing(CalcifiedPiecesSamplingDefinition::getMinSize);
                this.checkCpfDefinitionsValidity(definitionsComparator, (ArrayListMultimap<SpeciesProtocol, CalcifiedPiecesSamplingDefinition>)calcifiedPiecesSamplingDefinitionsWithoutMaturity);
                this.checkCpfDefinitionsValidity(definitionsComparator, (ArrayListMultimap<SpeciesProtocol, CalcifiedPiecesSamplingDefinition>)calcifiedPiecesSamplingDefinitionsWithTrueMaturity);
                this.checkCpfDefinitionsValidity(definitionsComparator, (ArrayListMultimap<SpeciesProtocol, CalcifiedPiecesSamplingDefinition>)calcifiedPiecesSamplingDefinitionsWithFalseMaturity);
            }
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.import.cps.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
        return result;
    }

    public void exportCalcifiedPiecesSamplings(File file, Multimap<SpeciesProtocol, CalcifiedPiecesSamplingDefinition> cps, Map<String, Species> speciesByReferenceTaxonId) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cps to file: " + file));
        }
        ArrayList rows = new ArrayList();
        Binder binder = BinderFactory.newBinder(CalcifiedPiecesSamplingDefinition.class, CalcifiedPiecesSamplingRow.class);
        cps.keySet().forEach(speciesProtocol -> {
            Collection calcifiedPiecesSamplingDefinitions = cps.get(speciesProtocol);
            calcifiedPiecesSamplingDefinitions.forEach(cpsDef -> {
                CalcifiedPiecesSamplingRow row = new CalcifiedPiecesSamplingRow();
                binder.copy(cpsDef, (Object)row, new String[0]);
                String refTaxId = String.valueOf(speciesProtocol.getSpeciesReferenceTaxonId());
                Species species = (Species)speciesByReferenceTaxonId.get(refTaxId);
                row.setSpecies(species);
                rows.add(row);
            });
        });
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            CalcifiedPiecesSamplingRowModel csvModel = CalcifiedPiecesSamplingRowModel.forExport(this.getCsvSeparator());
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.cps.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }

    protected void cleanRptData(SpeciesProtocol sp) {
        Rtp rtpUndefined;
        Rtp rtpFemale;
        Rtp rtpMale;
        if (sp.withRtpMale() && (rtpMale = sp.getRtpMale()).getA() == null && rtpMale.getB() == null) {
            sp.setRtpMale(null);
        }
        if (sp.withRtpFemale() && (rtpFemale = sp.getRtpFemale()).getA() == null && rtpFemale.getB() == null) {
            sp.setRtpFemale(null);
        }
        if (sp.withRtpUndefined() && (rtpUndefined = sp.getRtpUndefined()).getA() == null && rtpUndefined.getB() == null) {
            sp.setRtpUndefined(null);
        }
    }

    protected void checkCpfDefinitionsValidity(Comparator<CalcifiedPiecesSamplingDefinition> definitionsComparator, ArrayListMultimap<SpeciesProtocol, CalcifiedPiecesSamplingDefinition> calcifiedPiecesSamplingDefinitions) {
        calcifiedPiecesSamplingDefinitions.asMap().forEach((speciesProtocol, unsortedDefinitions) -> {
            ArrayList sortedDefinitions = new ArrayList(unsortedDefinitions);
            sortedDefinitions.sort(definitionsComparator);
            Integer min = -1;
            for (CalcifiedPiecesSamplingDefinition definition : sortedDefinitions) {
                if (definition.getMinSize() != min + 1) {
                    throw new ImportRuntimeException(I18n.t((String)"tutti.service.protocol.import.cps.interval.error", (Object[])new Object[]{speciesProtocol.getSpeciesReferenceTaxonId(), definition.getMaturity(), min, definition.getMinSize()}));
                }
                min = definition.getMaxSize();
            }
            speciesProtocol.setCalcifiedPiecesSamplingDefinition(sortedDefinitions);
        });
    }

    private Map<Integer, SpeciesProtocol> availableSpeciesProtocolMap(TuttiProtocol protocol) {
        ArrayList availableSpeciesProtocol = new ArrayList();
        if (!protocol.isSpeciesEmpty()) {
            availableSpeciesProtocol.addAll(protocol.getSpecies());
        }
        if (!protocol.isBenthosEmpty()) {
            availableSpeciesProtocol.addAll(protocol.getBenthos());
        }
        return availableSpeciesProtocol.stream().filter(SpeciesProtocol::isCalcifiedPiecesSamplingDefinitionEmpty).collect(Collectors.toMap(SpeciesProtocol::getSpeciesReferenceTaxonId, Function.identity()));
    }

    private static class SpeciesProtocolToSpeciesRowFunction
    implements Function<SpeciesProtocol, SpeciesRow> {
        private final Map<String, Species> speciesMap;
        private final Map<String, Caracteristic> caracteristicMap;
        private final Binder<SpeciesProtocol, SpeciesRow> binder;

        public SpeciesProtocolToSpeciesRowFunction(Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
            this.speciesMap = speciesMap;
            this.caracteristicMap = caracteristicMap;
            this.binder = BinderFactory.newBinder(SpeciesProtocol.class, SpeciesRow.class);
        }

        @Override
        public SpeciesRow apply(SpeciesProtocol input) {
            Species species = this.speciesMap.get(String.valueOf(input.getSpeciesReferenceTaxonId()));
            Preconditions.checkNotNull((Object)species, (Object)("Could not find a species with id: " + input));
            SpeciesRow result = new SpeciesRow();
            this.binder.copy((Object)input, (Object)result, new String[0]);
            String pmfmId = input.getLengthStepPmfmId();
            if (pmfmId != null) {
                Caracteristic caracteristic = this.caracteristicMap.get(pmfmId);
                result.setLengthStepPmfm(caracteristic);
            }
            result.setSpecies(species);
            result.setMandatorySampleCategoryId(new ArrayList<Integer>(input.getMandatorySampleCategoryId()));
            return result;
        }
    }
}

